/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.CreateIamRoleRequest;
import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.IamRole;
import com.okta.sdk.resource.model.IamRoles;
import com.okta.sdk.resource.model.UpdateIamRoleRequest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class RoleECustomApi {

    private ApiClient apiClient;

    public RoleECustomApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RoleECustomApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create a Custom Role Creates a Custom Role
     *
     * @param instance
     *            (required)
     *
     * @return IamRole
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IamRole createRole(CreateIamRoleRequest instance) throws ApiException {
        return this.createRole(instance, Collections.emptyMap());
    }

    /**
     * Create a Custom Role Creates a Custom Role
     *
     * @param instance
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return IamRole
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IamRole createRole(CreateIamRoleRequest instance, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = instance;

        // verify the required parameter 'instance' is set
        if (instance == null) {
            throw new ApiException(400, "Missing the required parameter 'instance' when calling createRole");
        }

        // create path and map variables
        String localVarPath = "/api/v1/iam/roles";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<IamRole> localVarReturnType = new TypeReference<IamRole>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete a Custom Role Deletes a Custom Role by &#x60;roleIdOrLabel&#x60;
     *
     * @param roleIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; of the Role (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteRole(String roleIdOrLabel) throws ApiException {
        this.deleteRole(roleIdOrLabel, Collections.emptyMap());
    }

    /**
     * Delete a Custom Role Deletes a Custom Role by &#x60;roleIdOrLabel&#x60;
     *
     * @param roleIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; of the Role (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteRole(String roleIdOrLabel, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'roleIdOrLabel' is set
        if (roleIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'roleIdOrLabel' when calling deleteRole");
        }

        // create path and map variables
        String localVarPath = "/api/v1/iam/roles/{roleIdOrLabel}".replaceAll("\\{" + "roleIdOrLabel" + "\\}",
                apiClient.escapeString(roleIdOrLabel.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve a Role Retrieves a role by &#x60;roleIdOrLabel&#x60;
     *
     * @param roleIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; of the Role (required)
     *
     * @return IamRole
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IamRole getRole(String roleIdOrLabel) throws ApiException {
        return this.getRole(roleIdOrLabel, Collections.emptyMap());
    }

    /**
     * Retrieve a Role Retrieves a role by &#x60;roleIdOrLabel&#x60;
     *
     * @param roleIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; of the Role (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return IamRole
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IamRole getRole(String roleIdOrLabel, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'roleIdOrLabel' is set
        if (roleIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'roleIdOrLabel' when calling getRole");
        }

        // create path and map variables
        String localVarPath = "/api/v1/iam/roles/{roleIdOrLabel}".replaceAll("\\{" + "roleIdOrLabel" + "\\}",
                apiClient.escapeString(roleIdOrLabel.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<IamRole> localVarReturnType = new TypeReference<IamRole>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Custom Roles Lists all Custom Roles with pagination support
     *
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     *
     * @return IamRoles
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IamRoles listRoles(String after) throws ApiException {
        return this.listRoles(after, Collections.emptyMap());
    }

    /**
     * List all Custom Roles Lists all Custom Roles with pagination support
     *
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return IamRoles
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IamRoles listRoles(String after, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/iam/roles";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<IamRoles> localVarReturnType = new TypeReference<IamRoles>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace a Custom Role Replaces the label and description for a Custom Role by &#x60;roleIdOrLabel&#x60;
     *
     * @param roleIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; of the Role (required)
     * @param instance
     *            (required)
     *
     * @return IamRole
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IamRole replaceRole(String roleIdOrLabel, UpdateIamRoleRequest instance) throws ApiException {
        return this.replaceRole(roleIdOrLabel, instance, Collections.emptyMap());
    }

    /**
     * Replace a Custom Role Replaces the label and description for a Custom Role by &#x60;roleIdOrLabel&#x60;
     *
     * @param roleIdOrLabel
     *            &#x60;id&#x60; or &#x60;label&#x60; of the Role (required)
     * @param instance
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return IamRole
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public IamRole replaceRole(String roleIdOrLabel, UpdateIamRoleRequest instance,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = instance;

        // verify the required parameter 'roleIdOrLabel' is set
        if (roleIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'roleIdOrLabel' when calling replaceRole");
        }

        // verify the required parameter 'instance' is set
        if (instance == null) {
            throw new ApiException(400, "Missing the required parameter 'instance' when calling replaceRole");
        }

        // create path and map variables
        String localVarPath = "/api/v1/iam/roles/{roleIdOrLabel}".replaceAll("\\{" + "roleIdOrLabel" + "\\}",
                apiClient.escapeString(roleIdOrLabel.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<IamRole> localVarReturnType = new TypeReference<IamRole>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
