/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.LogEvent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class SystemLogApi {

    private ApiClient apiClient;

    public SystemLogApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SystemLogApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * List all System Log Events Lists all System Log Events
     *
     * @param since
     *            Filters the lower time bound of the log events &#x60;published&#x60; property for bounded queries or
     *            persistence time for polling queries (optional, default to 7 days prior to until)
     * @param until
     *            Filters the upper time bound of the log events &#x60;published&#x60; property for bounded queries or
     *            persistence time for polling queries. (optional, default to current time)
     * @param after
     *            Retrieves the next page of results. Okta returns a link in the HTTP Header (&#x60;rel&#x3D;next&#x60;)
     *            that includes the after query parameter (optional)
     * @param filter
     *            Filter expression that filters the results. All operators except [ ] are supported. See
     *            [Filter](https://developer.okta.com/docs/api/#filter). (optional)
     * @param q
     *            Filters log events results by one or more case insensitive keywords. (optional)
     * @param limit
     *            Sets the number of results that are returned in the response (optional, default to 100)
     * @param sortOrder
     *            The order of the returned events that are sorted by the &#x60;published&#x60; property (optional,
     *            default to ASCENDING)
     *
     * @return List&lt;LogEvent&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<LogEvent> listLogEvents(String since, String until, String after, String filter, String q,
            Integer limit, String sortOrder) throws ApiException {
        return this.listLogEvents(since, until, after, filter, q, limit, sortOrder, Collections.emptyMap());
    }

    /**
     * List all System Log Events Lists all System Log Events
     *
     * @param since
     *            Filters the lower time bound of the log events &#x60;published&#x60; property for bounded queries or
     *            persistence time for polling queries (optional, default to 7 days prior to until)
     * @param until
     *            Filters the upper time bound of the log events &#x60;published&#x60; property for bounded queries or
     *            persistence time for polling queries. (optional, default to current time)
     * @param after
     *            Retrieves the next page of results. Okta returns a link in the HTTP Header (&#x60;rel&#x3D;next&#x60;)
     *            that includes the after query parameter (optional)
     * @param filter
     *            Filter expression that filters the results. All operators except [ ] are supported. See
     *            [Filter](https://developer.okta.com/docs/api/#filter). (optional)
     * @param q
     *            Filters log events results by one or more case insensitive keywords. (optional)
     * @param limit
     *            Sets the number of results that are returned in the response (optional, default to 100)
     * @param sortOrder
     *            The order of the returned events that are sorted by the &#x60;published&#x60; property (optional,
     *            default to ASCENDING)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;LogEvent&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<LogEvent> listLogEvents(String since, String until, String after, String filter, String q,
            Integer limit, String sortOrder, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/logs";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("since", since));
        localVarQueryParams.addAll(apiClient.parameterToPair("until", until));
        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(apiClient.parameterToPair("filter", filter));
        localVarQueryParams.addAll(apiClient.parameterToPair("q", q));
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(apiClient.parameterToPair("sortOrder", sortOrder));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<LogEvent>> localVarReturnType = new TypeReference<List<LogEvent>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
