/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.ResendUserFactor;
import com.okta.sdk.resource.model.UploadYubikeyOtpTokenSeedRequest;
import com.okta.sdk.resource.model.UserFactor;
import com.okta.sdk.resource.model.UserFactorActivateRequest;
import com.okta.sdk.resource.model.UserFactorActivateResponse;
import com.okta.sdk.resource.model.UserFactorPushTransaction;
import com.okta.sdk.resource.model.UserFactorSecurityQuestionProfile;
import com.okta.sdk.resource.model.UserFactorSupported;
import com.okta.sdk.resource.model.UserFactorVerifyRequest;
import com.okta.sdk.resource.model.UserFactorVerifyResponse;
import com.okta.sdk.resource.model.UserFactorYubikeyOtpToken;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class UserFactorApi {

    private ApiClient apiClient;

    public UserFactorApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UserFactorApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Activate a Factor Activates a Factor. Some Factors (&#x60;call&#x60;, &#x60;email&#x60;, &#x60;push&#x60;,
     * &#x60;sms&#x60;, &#x60;token:software:totp&#x60;, &#x60;u2f&#x60;, and &#x60;webauthn&#x60;) require activation
     * to complete the enrollment process. Okta enforces a rate limit of five activation attempts within five minutes.
     * After a user exceeds the rate limit, Okta returns an error message. &gt; **Note**: If the user exceeds their SMS,
     * call, or email factor activate rate limit, then an OTP resend request
     * (&#x60;/api/v1/users/${userId}}/factors/${factorId}/resend&#x60;) isn&#39;t allowed for the same Factor.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param factorId
     *            ID of an existing user Factor (required)
     * @param body
     *            (optional)
     *
     * @return UserFactorActivateResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserFactorActivateResponse activateFactor(String userId, String factorId, UserFactorActivateRequest body)
            throws ApiException {
        return this.activateFactor(userId, factorId, body, Collections.emptyMap());
    }

    /**
     * Activate a Factor Activates a Factor. Some Factors (&#x60;call&#x60;, &#x60;email&#x60;, &#x60;push&#x60;,
     * &#x60;sms&#x60;, &#x60;token:software:totp&#x60;, &#x60;u2f&#x60;, and &#x60;webauthn&#x60;) require activation
     * to complete the enrollment process. Okta enforces a rate limit of five activation attempts within five minutes.
     * After a user exceeds the rate limit, Okta returns an error message. &gt; **Note**: If the user exceeds their SMS,
     * call, or email factor activate rate limit, then an OTP resend request
     * (&#x60;/api/v1/users/${userId}}/factors/${factorId}/resend&#x60;) isn&#39;t allowed for the same Factor.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param factorId
     *            ID of an existing user Factor (required)
     * @param body
     *            (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return UserFactorActivateResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserFactorActivateResponse activateFactor(String userId, String factorId, UserFactorActivateRequest body,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = body;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling activateFactor");
        }

        // verify the required parameter 'factorId' is set
        if (factorId == null) {
            throw new ApiException(400, "Missing the required parameter 'factorId' when calling activateFactor");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/factors/{factorId}/lifecycle/activate"
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()))
                .replaceAll("\\{" + "factorId" + "\\}", apiClient.escapeString(factorId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<UserFactorActivateResponse> localVarReturnType = new TypeReference<UserFactorActivateResponse>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Enroll a Factor Enrolls a supported Factor for the specified user &gt; **Note:** All responses return the
     * enrolled Factor with a status of either &#x60;PENDING_ACTIVATION&#x60;&#x60; or &#x60;ACTIVE&#x60;. ####
     * Additional SMS/Call Factor information * **Rate limits**: Okta may return a &#x60;429 Too Many Requests&#x60;
     * status code if you attempt to resend an SMS or a voice call challenge (OTP) within the same time window. The
     * current [rate limit](https://developer.okta.com/docs/reference/rate-limits/) is one SMS/CALL challenge per phone
     * number every 30 seconds. * **Existing phone numbers**: Okta may return a &#x60;400 Bad Request&#x60; status code
     * if a user attempts to enroll with a different phone number when the user has an existing mobile phone or has an
     * existing phone with voice call capability. A user can enroll only one mobile phone for &#x60;sms&#x60; and enroll
     * only one voice call capable phone for &#x60;call&#x60; factor. #### Additional WebAuthn Factor information
     * **Enroll WebAuthn response parameters** * For detailed information on the Webauthn standard, including an
     * up-to-date list of supported browsers, see [webauthn.me](https://a0.to/webauthnme-okta-docs). * In the enroll API
     * response, the &#x60;response._embedded.activation&#x60; object contains properties used to help the client to
     * create a new WebAuthn credential for use with Okta. See the [WebAuthn spec for
     * PublicKeyCredentialCreationOptions](https://www.w3.org/TR/webauthn/#dictionary-makecredentialoptions). ####
     * Additional Custom TOTP Factor information **Enroll Custom TOTP Factor** * The enrollment process involves passing
     * both the &#x60;factorProfileId&#x60; and &#x60;sharedSecret&#x60; properties for a token. * A Factor Profile
     * represents a particular configuration of the Custom TOTP factor. It includes certain properties that match the
     * hardware token that end users possess, such as the HMAC algorithm, passcode length, and time interval. There can
     * be multiple Custom TOTP factor profiles per org, but users can only enroll in one Custom TOTP factor. Admins can
     * [create Custom TOTP factor profiles](https://help.okta.com/okta_help.htm?id&#x3D;ext-mfa-totp) in the Admin
     * Console. Then, copy the &#x60;factorProfileId&#x60; from the Admin Console into the API request. *
     * &lt;x-lifecycle class&#x3D;\&quot;oie\&quot;&gt;&lt;/x-lifecycle&gt; For Custom TOTP enrollment, Okta
     * automaticaly enrolls a user with a &#x60;token:software:totp&#x60; factor and the &#x60;push&#x60; factor if the
     * user isn&#39;t currently enrolled with these factors.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param body
     *            Factor (required)
     * @param updatePhone
     *            If &#x60;true&#x60;, indicates that you are replacing the currently registered phone number for the
     *            specified user. This parameter is ignored if the existing phone number is used by an activated Factor.
     *            (optional, default to false)
     * @param templateId
     *            ID of an existing custom SMS template. See the [SMS Templates API](../Template). This parameter is
     *            only used by &#x60;sms&#x60; Factors. If the provided ID doesn&#39;t exist, the default template is
     *            used instead. (optional)
     * @param tokenLifetimeSeconds
     *            Defines how long the token remains valid (optional, default to 300)
     * @param activate
     *            If &#x60;true&#x60;, the factor is immediately activated as part of the enrollment. An activation
     *            process isn&#39;t required. Currently auto-activation is supported by &#x60;sms&#x60;,
     *            &#x60;call&#x60;, &#x60;email&#x60; and &#x60;token:hotp&#x60; (Custom TOTP) Factor. (optional,
     *            default to false)
     * @param acceptLanguage
     *            An ISO 639-1 two-letter language code that defines a localized message to send. This parameter is only
     *            used by &#x60;sms&#x60; Factors. If a localized message doesn&#39;t exist or the
     *            &#x60;templateId&#x60; is incorrect, the default template is used instead. (optional)
     *
     * @return UserFactor
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserFactor enrollFactor(String userId, UserFactor body, Boolean updatePhone, String templateId,
            Integer tokenLifetimeSeconds, Boolean activate, String acceptLanguage) throws ApiException {
        return this.enrollFactor(userId, body, updatePhone, templateId, tokenLifetimeSeconds, activate, acceptLanguage,
                Collections.emptyMap());
    }

    /**
     * Enroll a Factor Enrolls a supported Factor for the specified user &gt; **Note:** All responses return the
     * enrolled Factor with a status of either &#x60;PENDING_ACTIVATION&#x60;&#x60; or &#x60;ACTIVE&#x60;. ####
     * Additional SMS/Call Factor information * **Rate limits**: Okta may return a &#x60;429 Too Many Requests&#x60;
     * status code if you attempt to resend an SMS or a voice call challenge (OTP) within the same time window. The
     * current [rate limit](https://developer.okta.com/docs/reference/rate-limits/) is one SMS/CALL challenge per phone
     * number every 30 seconds. * **Existing phone numbers**: Okta may return a &#x60;400 Bad Request&#x60; status code
     * if a user attempts to enroll with a different phone number when the user has an existing mobile phone or has an
     * existing phone with voice call capability. A user can enroll only one mobile phone for &#x60;sms&#x60; and enroll
     * only one voice call capable phone for &#x60;call&#x60; factor. #### Additional WebAuthn Factor information
     * **Enroll WebAuthn response parameters** * For detailed information on the Webauthn standard, including an
     * up-to-date list of supported browsers, see [webauthn.me](https://a0.to/webauthnme-okta-docs). * In the enroll API
     * response, the &#x60;response._embedded.activation&#x60; object contains properties used to help the client to
     * create a new WebAuthn credential for use with Okta. See the [WebAuthn spec for
     * PublicKeyCredentialCreationOptions](https://www.w3.org/TR/webauthn/#dictionary-makecredentialoptions). ####
     * Additional Custom TOTP Factor information **Enroll Custom TOTP Factor** * The enrollment process involves passing
     * both the &#x60;factorProfileId&#x60; and &#x60;sharedSecret&#x60; properties for a token. * A Factor Profile
     * represents a particular configuration of the Custom TOTP factor. It includes certain properties that match the
     * hardware token that end users possess, such as the HMAC algorithm, passcode length, and time interval. There can
     * be multiple Custom TOTP factor profiles per org, but users can only enroll in one Custom TOTP factor. Admins can
     * [create Custom TOTP factor profiles](https://help.okta.com/okta_help.htm?id&#x3D;ext-mfa-totp) in the Admin
     * Console. Then, copy the &#x60;factorProfileId&#x60; from the Admin Console into the API request. *
     * &lt;x-lifecycle class&#x3D;\&quot;oie\&quot;&gt;&lt;/x-lifecycle&gt; For Custom TOTP enrollment, Okta
     * automaticaly enrolls a user with a &#x60;token:software:totp&#x60; factor and the &#x60;push&#x60; factor if the
     * user isn&#39;t currently enrolled with these factors.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param body
     *            Factor (required)
     * @param updatePhone
     *            If &#x60;true&#x60;, indicates that you are replacing the currently registered phone number for the
     *            specified user. This parameter is ignored if the existing phone number is used by an activated Factor.
     *            (optional, default to false)
     * @param templateId
     *            ID of an existing custom SMS template. See the [SMS Templates API](../Template). This parameter is
     *            only used by &#x60;sms&#x60; Factors. If the provided ID doesn&#39;t exist, the default template is
     *            used instead. (optional)
     * @param tokenLifetimeSeconds
     *            Defines how long the token remains valid (optional, default to 300)
     * @param activate
     *            If &#x60;true&#x60;, the factor is immediately activated as part of the enrollment. An activation
     *            process isn&#39;t required. Currently auto-activation is supported by &#x60;sms&#x60;,
     *            &#x60;call&#x60;, &#x60;email&#x60; and &#x60;token:hotp&#x60; (Custom TOTP) Factor. (optional,
     *            default to false)
     * @param acceptLanguage
     *            An ISO 639-1 two-letter language code that defines a localized message to send. This parameter is only
     *            used by &#x60;sms&#x60; Factors. If a localized message doesn&#39;t exist or the
     *            &#x60;templateId&#x60; is incorrect, the default template is used instead. (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return UserFactor
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserFactor enrollFactor(String userId, UserFactor body, Boolean updatePhone, String templateId,
            Integer tokenLifetimeSeconds, Boolean activate, String acceptLanguage,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = body;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling enrollFactor");
        }

        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling enrollFactor");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/factors".replaceAll("\\{" + "userId" + "\\}",
                apiClient.escapeString(userId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("updatePhone", updatePhone));
        localVarQueryParams.addAll(apiClient.parameterToPair("templateId", templateId));
        localVarQueryParams.addAll(apiClient.parameterToPair("tokenLifetimeSeconds", tokenLifetimeSeconds));
        localVarQueryParams.addAll(apiClient.parameterToPair("activate", activate));
        if (acceptLanguage != null)
            localVarHeaderParams.put("Accept-Language", apiClient.parameterToString(acceptLanguage));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<UserFactor> localVarReturnType = new TypeReference<UserFactor>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve a Factor Retrieves an existing Factor for the specified user
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param factorId
     *            ID of an existing user Factor (required)
     *
     * @return UserFactor
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserFactor getFactor(String userId, String factorId) throws ApiException {
        return this.getFactor(userId, factorId, Collections.emptyMap());
    }

    /**
     * Retrieve a Factor Retrieves an existing Factor for the specified user
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param factorId
     *            ID of an existing user Factor (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return UserFactor
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserFactor getFactor(String userId, String factorId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getFactor");
        }

        // verify the required parameter 'factorId' is set
        if (factorId == null) {
            throw new ApiException(400, "Missing the required parameter 'factorId' when calling getFactor");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/factors/{factorId}"
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()))
                .replaceAll("\\{" + "factorId" + "\\}", apiClient.escapeString(factorId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<UserFactor> localVarReturnType = new TypeReference<UserFactor>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve a Factor transaction status Retrieves the status of a &#x60;push&#x60; Factor verification transaction
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param factorId
     *            ID of an existing user Factor (required)
     * @param transactionId
     *            ID of an existing Factor verification transaction (required)
     *
     * @return UserFactorPushTransaction
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserFactorPushTransaction getFactorTransactionStatus(String userId, String factorId, String transactionId)
            throws ApiException {
        return this.getFactorTransactionStatus(userId, factorId, transactionId, Collections.emptyMap());
    }

    /**
     * Retrieve a Factor transaction status Retrieves the status of a &#x60;push&#x60; Factor verification transaction
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param factorId
     *            ID of an existing user Factor (required)
     * @param transactionId
     *            ID of an existing Factor verification transaction (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return UserFactorPushTransaction
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserFactorPushTransaction getFactorTransactionStatus(String userId, String factorId, String transactionId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'userId' when calling getFactorTransactionStatus");
        }

        // verify the required parameter 'factorId' is set
        if (factorId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'factorId' when calling getFactorTransactionStatus");
        }

        // verify the required parameter 'transactionId' is set
        if (transactionId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'transactionId' when calling getFactorTransactionStatus");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/factors/{factorId}/transactions/{transactionId}"
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()))
                .replaceAll("\\{" + "factorId" + "\\}", apiClient.escapeString(factorId.toString()))
                .replaceAll("\\{" + "transactionId" + "\\}", apiClient.escapeString(transactionId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<UserFactorPushTransaction> localVarReturnType = new TypeReference<UserFactorPushTransaction>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve a YubiKey OTP Token Retrieves the specified YubiKey OTP Token by &#x60;id&#x60;
     *
     * @param tokenId
     *            ID of a Yubikey token (required)
     *
     * @return UserFactorYubikeyOtpToken
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserFactorYubikeyOtpToken getYubikeyOtpTokenById(String tokenId) throws ApiException {
        return this.getYubikeyOtpTokenById(tokenId, Collections.emptyMap());
    }

    /**
     * Retrieve a YubiKey OTP Token Retrieves the specified YubiKey OTP Token by &#x60;id&#x60;
     *
     * @param tokenId
     *            ID of a Yubikey token (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return UserFactorYubikeyOtpToken
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserFactorYubikeyOtpToken getYubikeyOtpTokenById(String tokenId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'tokenId' is set
        if (tokenId == null) {
            throw new ApiException(400, "Missing the required parameter 'tokenId' when calling getYubikeyOtpTokenById");
        }

        // create path and map variables
        String localVarPath = "/api/v1/org/factors/yubikey_token/tokens/{tokenId}".replaceAll("\\{" + "tokenId" + "\\}",
                apiClient.escapeString(tokenId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<UserFactorYubikeyOtpToken> localVarReturnType = new TypeReference<UserFactorYubikeyOtpToken>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all enrolled Factors Lists all enrolled Factors for the specified user
     *
     * @param userId
     *            ID of an existing Okta user (required)
     *
     * @return List&lt;UserFactor&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<UserFactor> listFactors(String userId) throws ApiException {
        return this.listFactors(userId, Collections.emptyMap());
    }

    /**
     * List all enrolled Factors Lists all enrolled Factors for the specified user
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;UserFactor&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<UserFactor> listFactors(String userId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listFactors");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/factors".replaceAll("\\{" + "userId" + "\\}",
                apiClient.escapeString(userId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<UserFactor>> localVarReturnType = new TypeReference<List<UserFactor>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all supported Factors Lists all the supported Factors that can be enrolled for the specified user
     *
     * @param userId
     *            ID of an existing Okta user (required)
     *
     * @return List&lt;UserFactorSupported&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<UserFactorSupported> listSupportedFactors(String userId) throws ApiException {
        return this.listSupportedFactors(userId, Collections.emptyMap());
    }

    /**
     * List all supported Factors Lists all the supported Factors that can be enrolled for the specified user
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;UserFactorSupported&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<UserFactorSupported> listSupportedFactors(String userId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listSupportedFactors");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/factors/catalog".replaceAll("\\{" + "userId" + "\\}",
                apiClient.escapeString(userId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<UserFactorSupported>> localVarReturnType = new TypeReference<List<UserFactorSupported>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all supported Security Questions Lists all available Security Questions for the specified user
     *
     * @param userId
     *            ID of an existing Okta user (required)
     *
     * @return List&lt;UserFactorSecurityQuestionProfile&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<UserFactorSecurityQuestionProfile> listSupportedSecurityQuestions(String userId) throws ApiException {
        return this.listSupportedSecurityQuestions(userId, Collections.emptyMap());
    }

    /**
     * List all supported Security Questions Lists all available Security Questions for the specified user
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;UserFactorSecurityQuestionProfile&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<UserFactorSecurityQuestionProfile> listSupportedSecurityQuestions(String userId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'userId' when calling listSupportedSecurityQuestions");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/factors/questions".replaceAll("\\{" + "userId" + "\\}",
                apiClient.escapeString(userId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken" };

        TypeReference<List<UserFactorSecurityQuestionProfile>> localVarReturnType = new TypeReference<List<UserFactorSecurityQuestionProfile>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all YubiKey OTP Tokens Lists all YubiKey OTP Tokens
     *
     * @param after
     *            Specifies the pagination cursor for the next page of tokens (optional)
     * @param expand
     *            Embeds the [User](/openapi/okta-management/management/tag/User/) resource if the YubiKey Token is
     *            assigned to a user and &#x60;expand&#x60; is set to &#x60;user&#x60; (optional)
     * @param filter
     *            The expression used to filter tokens (optional)
     * @param forDownload
     *            Returns tokens in a CSV to download instead of in the response. When you use this query parameter, the
     *            &#x60;limit&#x60; default changes to 1000. (optional, default to false)
     * @param limit
     *            Specifies the number of results per page (optional, default to 20)
     * @param sortBy
     *            The value of how the tokens are sorted (optional)
     * @param sortOrder
     *            Specifies the sort order, either &#x60;ASC&#x60; or &#x60;DESC&#x60; (optional)
     *
     * @return List&lt;UserFactorYubikeyOtpToken&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<UserFactorYubikeyOtpToken> listYubikeyOtpTokens(String after, String expand, String filter,
            Boolean forDownload, Integer limit, String sortBy, String sortOrder) throws ApiException {
        return this.listYubikeyOtpTokens(after, expand, filter, forDownload, limit, sortBy, sortOrder,
                Collections.emptyMap());
    }

    /**
     * List all YubiKey OTP Tokens Lists all YubiKey OTP Tokens
     *
     * @param after
     *            Specifies the pagination cursor for the next page of tokens (optional)
     * @param expand
     *            Embeds the [User](/openapi/okta-management/management/tag/User/) resource if the YubiKey Token is
     *            assigned to a user and &#x60;expand&#x60; is set to &#x60;user&#x60; (optional)
     * @param filter
     *            The expression used to filter tokens (optional)
     * @param forDownload
     *            Returns tokens in a CSV to download instead of in the response. When you use this query parameter, the
     *            &#x60;limit&#x60; default changes to 1000. (optional, default to false)
     * @param limit
     *            Specifies the number of results per page (optional, default to 20)
     * @param sortBy
     *            The value of how the tokens are sorted (optional)
     * @param sortOrder
     *            Specifies the sort order, either &#x60;ASC&#x60; or &#x60;DESC&#x60; (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;UserFactorYubikeyOtpToken&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<UserFactorYubikeyOtpToken> listYubikeyOtpTokens(String after, String expand, String filter,
            Boolean forDownload, Integer limit, String sortBy, String sortOrder, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/org/factors/yubikey_token/tokens";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(apiClient.parameterToPair("expand", expand));
        localVarQueryParams.addAll(apiClient.parameterToPair("filter", filter));
        localVarQueryParams.addAll(apiClient.parameterToPair("forDownload", forDownload));
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(apiClient.parameterToPair("sortBy", sortBy));
        localVarQueryParams.addAll(apiClient.parameterToPair("sortOrder", sortOrder));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<UserFactorYubikeyOtpToken>> localVarReturnType = new TypeReference<List<UserFactorYubikeyOtpToken>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Resend a Factor enrollment Resends an &#x60;sms&#x60;, &#x60;call&#x60;, or &#x60;email&#x60; factor challenge as
     * part of an enrollment flow For &#x60;call&#x60; and &#x60;sms&#x60; factors, Okta enforces a rate limit of one
     * OTP challenge per device every 30 seconds. You can configure your &#x60;sms&#x60; and &#x60;call&#x60; factors to
     * use a third-party telephony provider. See the [Telephony inline hook
     * reference](https://developer.okta.com/docs/reference/telephony-hook/). Okta round-robins between SMS providers
     * with every resend request to help ensure delivery of an SMS and Call OTPs across different carriers. &gt;
     * **Note**: Resend operations aren&#39;t allowed after a factor exceeds the activation rate limit. See [Activate a
     * Factor](./#tag/UserFactor/operation/activateFactor).
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param factorId
     *            ID of an existing user Factor (required)
     * @param resendUserFactor
     *            (required)
     * @param templateId
     *            ID of an existing custom SMS template. See the [SMS Templates API](../Template). This parameter is
     *            only used by &#x60;sms&#x60; Factors. (optional)
     *
     * @return ResendUserFactor
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ResendUserFactor resendEnrollFactor(String userId, String factorId, ResendUserFactor resendUserFactor,
            String templateId) throws ApiException {
        return this.resendEnrollFactor(userId, factorId, resendUserFactor, templateId, Collections.emptyMap());
    }

    /**
     * Resend a Factor enrollment Resends an &#x60;sms&#x60;, &#x60;call&#x60;, or &#x60;email&#x60; factor challenge as
     * part of an enrollment flow For &#x60;call&#x60; and &#x60;sms&#x60; factors, Okta enforces a rate limit of one
     * OTP challenge per device every 30 seconds. You can configure your &#x60;sms&#x60; and &#x60;call&#x60; factors to
     * use a third-party telephony provider. See the [Telephony inline hook
     * reference](https://developer.okta.com/docs/reference/telephony-hook/). Okta round-robins between SMS providers
     * with every resend request to help ensure delivery of an SMS and Call OTPs across different carriers. &gt;
     * **Note**: Resend operations aren&#39;t allowed after a factor exceeds the activation rate limit. See [Activate a
     * Factor](./#tag/UserFactor/operation/activateFactor).
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param factorId
     *            ID of an existing user Factor (required)
     * @param resendUserFactor
     *            (required)
     * @param templateId
     *            ID of an existing custom SMS template. See the [SMS Templates API](../Template). This parameter is
     *            only used by &#x60;sms&#x60; Factors. (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ResendUserFactor
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ResendUserFactor resendEnrollFactor(String userId, String factorId, ResendUserFactor resendUserFactor,
            String templateId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = resendUserFactor;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling resendEnrollFactor");
        }

        // verify the required parameter 'factorId' is set
        if (factorId == null) {
            throw new ApiException(400, "Missing the required parameter 'factorId' when calling resendEnrollFactor");
        }

        // verify the required parameter 'resendUserFactor' is set
        if (resendUserFactor == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'resendUserFactor' when calling resendEnrollFactor");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/factors/{factorId}/resend"
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()))
                .replaceAll("\\{" + "factorId" + "\\}", apiClient.escapeString(factorId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("templateId", templateId));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ResendUserFactor> localVarReturnType = new TypeReference<ResendUserFactor>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Unenroll a Factor Unenrolls an existing Factor for the specified user. This allows the user to enroll a new
     * Factor. &gt; **Note**: If you unenroll the &#x60;push&#x60; or the &#x60;signed_nonce&#x60; Factors, Okta also
     * unenrolls any other &#x60;totp&#x60;, &#x60;signed_nonce&#x60;, or Okta Verify &#x60;push&#x60; Factors
     * associated with the user.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param factorId
     *            ID of an existing user Factor (required)
     * @param removeRecoveryEnrollment
     *            If &#x60;true&#x60;, removes the phone number as both a recovery method and a Factor. This parameter
     *            is only used for the &#x60;sms&#x60; and &#x60;call&#x60; Factors. (optional, default to false)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void unenrollFactor(String userId, String factorId, Boolean removeRecoveryEnrollment) throws ApiException {
        this.unenrollFactor(userId, factorId, removeRecoveryEnrollment, Collections.emptyMap());
    }

    /**
     * Unenroll a Factor Unenrolls an existing Factor for the specified user. This allows the user to enroll a new
     * Factor. &gt; **Note**: If you unenroll the &#x60;push&#x60; or the &#x60;signed_nonce&#x60; Factors, Okta also
     * unenrolls any other &#x60;totp&#x60;, &#x60;signed_nonce&#x60;, or Okta Verify &#x60;push&#x60; Factors
     * associated with the user.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param factorId
     *            ID of an existing user Factor (required)
     * @param removeRecoveryEnrollment
     *            If &#x60;true&#x60;, removes the phone number as both a recovery method and a Factor. This parameter
     *            is only used for the &#x60;sms&#x60; and &#x60;call&#x60; Factors. (optional, default to false)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void unenrollFactor(String userId, String factorId, Boolean removeRecoveryEnrollment,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling unenrollFactor");
        }

        // verify the required parameter 'factorId' is set
        if (factorId == null) {
            throw new ApiException(400, "Missing the required parameter 'factorId' when calling unenrollFactor");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/factors/{factorId}"
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()))
                .replaceAll("\\{" + "factorId" + "\\}", apiClient.escapeString(factorId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("removeRecoveryEnrollment", removeRecoveryEnrollment));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Upload a YubiKey OTP Seed Uploads a seed for a user to enroll a YubiKey OTP
     *
     * @param uploadYubikeyOtpTokenSeedRequest
     *            (required)
     * @param after
     *            Specifies the pagination cursor for the next page of tokens (optional)
     * @param expand
     *            Embeds the [User](/openapi/okta-management/management/tag/User/) resource if the YubiKey Token is
     *            assigned to a user and &#x60;expand&#x60; is set to &#x60;user&#x60; (optional)
     * @param filter
     *            The expression used to filter tokens (optional)
     * @param forDownload
     *            Returns tokens in a CSV to download instead of in the response. When you use this query parameter, the
     *            &#x60;limit&#x60; default changes to 1000. (optional, default to false)
     * @param limit
     *            Specifies the number of results per page (optional, default to 20)
     * @param sortBy
     *            The value of how the tokens are sorted (optional)
     * @param sortOrder
     *            Specifies the sort order, either &#x60;ASC&#x60; or &#x60;DESC&#x60; (optional)
     *
     * @return UserFactorYubikeyOtpToken
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserFactorYubikeyOtpToken uploadYubikeyOtpTokenSeed(
            UploadYubikeyOtpTokenSeedRequest uploadYubikeyOtpTokenSeedRequest, String after, String expand,
            String filter, Boolean forDownload, Integer limit, String sortBy, String sortOrder) throws ApiException {
        return this.uploadYubikeyOtpTokenSeed(uploadYubikeyOtpTokenSeedRequest, after, expand, filter, forDownload,
                limit, sortBy, sortOrder, Collections.emptyMap());
    }

    /**
     * Upload a YubiKey OTP Seed Uploads a seed for a user to enroll a YubiKey OTP
     *
     * @param uploadYubikeyOtpTokenSeedRequest
     *            (required)
     * @param after
     *            Specifies the pagination cursor for the next page of tokens (optional)
     * @param expand
     *            Embeds the [User](/openapi/okta-management/management/tag/User/) resource if the YubiKey Token is
     *            assigned to a user and &#x60;expand&#x60; is set to &#x60;user&#x60; (optional)
     * @param filter
     *            The expression used to filter tokens (optional)
     * @param forDownload
     *            Returns tokens in a CSV to download instead of in the response. When you use this query parameter, the
     *            &#x60;limit&#x60; default changes to 1000. (optional, default to false)
     * @param limit
     *            Specifies the number of results per page (optional, default to 20)
     * @param sortBy
     *            The value of how the tokens are sorted (optional)
     * @param sortOrder
     *            Specifies the sort order, either &#x60;ASC&#x60; or &#x60;DESC&#x60; (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return UserFactorYubikeyOtpToken
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserFactorYubikeyOtpToken uploadYubikeyOtpTokenSeed(
            UploadYubikeyOtpTokenSeedRequest uploadYubikeyOtpTokenSeedRequest, String after, String expand,
            String filter, Boolean forDownload, Integer limit, String sortBy, String sortOrder,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = uploadYubikeyOtpTokenSeedRequest;

        // verify the required parameter 'uploadYubikeyOtpTokenSeedRequest' is set
        if (uploadYubikeyOtpTokenSeedRequest == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'uploadYubikeyOtpTokenSeedRequest' when calling uploadYubikeyOtpTokenSeed");
        }

        // create path and map variables
        String localVarPath = "/api/v1/org/factors/yubikey_token/tokens";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(apiClient.parameterToPair("expand", expand));
        localVarQueryParams.addAll(apiClient.parameterToPair("filter", filter));
        localVarQueryParams.addAll(apiClient.parameterToPair("forDownload", forDownload));
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(apiClient.parameterToPair("sortBy", sortBy));
        localVarQueryParams.addAll(apiClient.parameterToPair("sortOrder", sortOrder));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<UserFactorYubikeyOtpToken> localVarReturnType = new TypeReference<UserFactorYubikeyOtpToken>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Verify a Factor Verifies an OTP for a Factor. Some Factors (&#x60;call&#x60;, &#x60;email&#x60;,
     * &#x60;push&#x60;, &#x60;sms&#x60;, &#x60;u2f&#x60;, and &#x60;webauthn&#x60;) must first issue a challenge before
     * you can verify the Factor. Do this by making a request without a body. After a challenge is issued, make another
     * request to verify the Factor. **Note**: To verify a &#x60;push&#x60; factor, use the **poll** link returned when
     * you issue the challenge. See [Retrieve a Factor Transaction
     * Status](/openapi/okta-management/management/tag/UserFactor/#tag/UserFactor/operation/getFactorTransactionStatus).
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param factorId
     *            ID of an existing user Factor (required)
     * @param templateId
     *            ID of an existing custom SMS template. See the [SMS Templates API](../Template). This parameter is
     *            only used by &#x60;sms&#x60; Factors. (optional)
     * @param tokenLifetimeSeconds
     *            Defines how long the token remains valid (optional, default to 300)
     * @param xForwardedFor
     *            Public IP address for the user agent (optional)
     * @param userAgent
     *            Type of user agent detected when the request is made. Required to verify &#x60;push&#x60; Factors.
     *            (optional)
     * @param acceptLanguage
     *            An ISO 639-1 two-letter language code that defines a localized message to send. This parameter is only
     *            used by &#x60;sms&#x60; Factors. If a localized message doesn&#39;t exist or the
     *            &#x60;templateId&#x60; is incorrect, the default template is used instead. (optional)
     * @param body
     *            Some Factors (&#x60;call&#x60;, &#x60;email&#x60;, &#x60;push&#x60;, &#x60;sms&#x60;, &#x60;u2f&#x60;,
     *            and &#x60;webauthn&#x60;) must first issue a challenge before you can verify the Factor. Do this by
     *            making a request without a body. After a challenge is issued, make another request to verify the
     *            Factor. (optional)
     *
     * @return UserFactorVerifyResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserFactorVerifyResponse verifyFactor(String userId, String factorId, String templateId,
            Integer tokenLifetimeSeconds, String xForwardedFor, String userAgent, String acceptLanguage,
            UserFactorVerifyRequest body) throws ApiException {
        return this.verifyFactor(userId, factorId, templateId, tokenLifetimeSeconds, xForwardedFor, userAgent,
                acceptLanguage, body, Collections.emptyMap());
    }

    /**
     * Verify a Factor Verifies an OTP for a Factor. Some Factors (&#x60;call&#x60;, &#x60;email&#x60;,
     * &#x60;push&#x60;, &#x60;sms&#x60;, &#x60;u2f&#x60;, and &#x60;webauthn&#x60;) must first issue a challenge before
     * you can verify the Factor. Do this by making a request without a body. After a challenge is issued, make another
     * request to verify the Factor. **Note**: To verify a &#x60;push&#x60; factor, use the **poll** link returned when
     * you issue the challenge. See [Retrieve a Factor Transaction
     * Status](/openapi/okta-management/management/tag/UserFactor/#tag/UserFactor/operation/getFactorTransactionStatus).
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param factorId
     *            ID of an existing user Factor (required)
     * @param templateId
     *            ID of an existing custom SMS template. See the [SMS Templates API](../Template). This parameter is
     *            only used by &#x60;sms&#x60; Factors. (optional)
     * @param tokenLifetimeSeconds
     *            Defines how long the token remains valid (optional, default to 300)
     * @param xForwardedFor
     *            Public IP address for the user agent (optional)
     * @param userAgent
     *            Type of user agent detected when the request is made. Required to verify &#x60;push&#x60; Factors.
     *            (optional)
     * @param acceptLanguage
     *            An ISO 639-1 two-letter language code that defines a localized message to send. This parameter is only
     *            used by &#x60;sms&#x60; Factors. If a localized message doesn&#39;t exist or the
     *            &#x60;templateId&#x60; is incorrect, the default template is used instead. (optional)
     * @param body
     *            Some Factors (&#x60;call&#x60;, &#x60;email&#x60;, &#x60;push&#x60;, &#x60;sms&#x60;, &#x60;u2f&#x60;,
     *            and &#x60;webauthn&#x60;) must first issue a challenge before you can verify the Factor. Do this by
     *            making a request without a body. After a challenge is issued, make another request to verify the
     *            Factor. (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return UserFactorVerifyResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserFactorVerifyResponse verifyFactor(String userId, String factorId, String templateId,
            Integer tokenLifetimeSeconds, String xForwardedFor, String userAgent, String acceptLanguage,
            UserFactorVerifyRequest body, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = body;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling verifyFactor");
        }

        // verify the required parameter 'factorId' is set
        if (factorId == null) {
            throw new ApiException(400, "Missing the required parameter 'factorId' when calling verifyFactor");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/factors/{factorId}/verify"
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()))
                .replaceAll("\\{" + "factorId" + "\\}", apiClient.escapeString(factorId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("templateId", templateId));
        localVarQueryParams.addAll(apiClient.parameterToPair("tokenLifetimeSeconds", tokenLifetimeSeconds));
        if (xForwardedFor != null)
            localVarHeaderParams.put("X-Forwarded-For", apiClient.parameterToString(xForwardedFor));
        if (userAgent != null)
            localVarHeaderParams.put("User-Agent", apiClient.parameterToString(userAgent));
        if (acceptLanguage != null)
            localVarHeaderParams.put("Accept-Language", apiClient.parameterToString(acceptLanguage));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<UserFactorVerifyResponse> localVarReturnType = new TypeReference<UserFactorVerifyResponse>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
