/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.OAuth2ScopeConsentGrant;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class UserGrantApi {

    private ApiClient apiClient;

    public UserGrantApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UserGrantApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Retrieve a User Grant Retrieves a Grant for the specified User
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param grantId
     *            Grant ID (required)
     * @param expand
     *            Valid value: &#x60;scope&#x60;. If specified, scope details are included in the &#x60;_embedded&#x60;
     *            attribute. (optional)
     *
     * @return OAuth2ScopeConsentGrant
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2ScopeConsentGrant getUserGrant(String userId, String grantId, String expand) throws ApiException {
        return this.getUserGrant(userId, grantId, expand, Collections.emptyMap());
    }

    /**
     * Retrieve a User Grant Retrieves a Grant for the specified User
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param grantId
     *            Grant ID (required)
     * @param expand
     *            Valid value: &#x60;scope&#x60;. If specified, scope details are included in the &#x60;_embedded&#x60;
     *            attribute. (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return OAuth2ScopeConsentGrant
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public OAuth2ScopeConsentGrant getUserGrant(String userId, String grantId, String expand,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getUserGrant");
        }

        // verify the required parameter 'grantId' is set
        if (grantId == null) {
            throw new ApiException(400, "Missing the required parameter 'grantId' when calling getUserGrant");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/grants/{grantId}"
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()))
                .replaceAll("\\{" + "grantId" + "\\}", apiClient.escapeString(grantId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("expand", expand));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<OAuth2ScopeConsentGrant> localVarReturnType = new TypeReference<OAuth2ScopeConsentGrant>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Grants for a Client Lists all Grants for a specified User and client
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param expand
     *            Valid value: &#x60;scope&#x60;. If specified, scope details are included in the &#x60;_embedded&#x60;
     *            attribute. (optional)
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param limit
     *            Specifies the number of tokens to return (optional, default to 20)
     *
     * @return List&lt;OAuth2ScopeConsentGrant&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<OAuth2ScopeConsentGrant> listGrantsForUserAndClient(String userId, String clientId, String expand,
            String after, Integer limit) throws ApiException {
        return this.listGrantsForUserAndClient(userId, clientId, expand, after, limit, Collections.emptyMap());
    }

    /**
     * List all Grants for a Client Lists all Grants for a specified User and client
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param expand
     *            Valid value: &#x60;scope&#x60;. If specified, scope details are included in the &#x60;_embedded&#x60;
     *            attribute. (optional)
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param limit
     *            Specifies the number of tokens to return (optional, default to 20)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;OAuth2ScopeConsentGrant&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<OAuth2ScopeConsentGrant> listGrantsForUserAndClient(String userId, String clientId, String expand,
            String after, Integer limit, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'userId' when calling listGrantsForUserAndClient");
        }

        // verify the required parameter 'clientId' is set
        if (clientId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'clientId' when calling listGrantsForUserAndClient");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/clients/{clientId}/grants"
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()))
                .replaceAll("\\{" + "clientId" + "\\}", apiClient.escapeString(clientId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("expand", expand));
        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<OAuth2ScopeConsentGrant>> localVarReturnType = new TypeReference<List<OAuth2ScopeConsentGrant>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all User Grants Lists all Grants for the specified user
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param scopeId
     *            The scope ID to filter on (optional)
     * @param expand
     *            Valid value: &#x60;scope&#x60;. If specified, scope details are included in the &#x60;_embedded&#x60;
     *            attribute. (optional)
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param limit
     *            Specifies the number of grants to return (optional, default to 20)
     *
     * @return List&lt;OAuth2ScopeConsentGrant&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<OAuth2ScopeConsentGrant> listUserGrants(String userId, String scopeId, String expand, String after,
            Integer limit) throws ApiException {
        return this.listUserGrants(userId, scopeId, expand, after, limit, Collections.emptyMap());
    }

    /**
     * List all User Grants Lists all Grants for the specified user
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param scopeId
     *            The scope ID to filter on (optional)
     * @param expand
     *            Valid value: &#x60;scope&#x60;. If specified, scope details are included in the &#x60;_embedded&#x60;
     *            attribute. (optional)
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param limit
     *            Specifies the number of grants to return (optional, default to 20)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;OAuth2ScopeConsentGrant&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<OAuth2ScopeConsentGrant> listUserGrants(String userId, String scopeId, String expand, String after,
            Integer limit, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listUserGrants");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/grants".replaceAll("\\{" + "userId" + "\\}",
                apiClient.escapeString(userId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("scopeId", scopeId));
        localVarQueryParams.addAll(apiClient.parameterToPair("expand", expand));
        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<OAuth2ScopeConsentGrant>> localVarReturnType = new TypeReference<List<OAuth2ScopeConsentGrant>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Revoke all Grants for a Client Revokes all Grants for the specified User and client
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void revokeGrantsForUserAndClient(String userId, String clientId) throws ApiException {
        this.revokeGrantsForUserAndClient(userId, clientId, Collections.emptyMap());
    }

    /**
     * Revoke all Grants for a Client Revokes all Grants for the specified User and client
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param clientId
     *            &#x60;client_id&#x60; of the app (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void revokeGrantsForUserAndClient(String userId, String clientId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'userId' when calling revokeGrantsForUserAndClient");
        }

        // verify the required parameter 'clientId' is set
        if (clientId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'clientId' when calling revokeGrantsForUserAndClient");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/clients/{clientId}/grants"
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()))
                .replaceAll("\\{" + "clientId" + "\\}", apiClient.escapeString(clientId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Revoke a User Grant Revokes one Grant for a specified User
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param grantId
     *            Grant ID (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void revokeUserGrant(String userId, String grantId) throws ApiException {
        this.revokeUserGrant(userId, grantId, Collections.emptyMap());
    }

    /**
     * Revoke a User Grant Revokes one Grant for a specified User
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param grantId
     *            Grant ID (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void revokeUserGrant(String userId, String grantId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling revokeUserGrant");
        }

        // verify the required parameter 'grantId' is set
        if (grantId == null) {
            throw new ApiException(400, "Missing the required parameter 'grantId' when calling revokeUserGrant");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/grants/{grantId}"
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()))
                .replaceAll("\\{" + "grantId" + "\\}", apiClient.escapeString(grantId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Revoke all User Grants Revokes all Grants for a specified User
     *
     * @param userId
     *            ID of an existing Okta user (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void revokeUserGrants(String userId) throws ApiException {
        this.revokeUserGrants(userId, Collections.emptyMap());
    }

    /**
     * Revoke all User Grants Revokes all Grants for a specified User
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void revokeUserGrants(String userId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling revokeUserGrants");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/grants".replaceAll("\\{" + "userId" + "\\}",
                apiClient.escapeString(userId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
