/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.CreateUserTypeRequest;
import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.UserType;
import com.okta.sdk.resource.model.UserTypePostRequest;
import com.okta.sdk.resource.model.UserTypePutRequest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class UserTypeApi {

    private ApiClient apiClient;

    public UserTypeApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UserTypeApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create a User Type Creates a new User Type. Okta automatically creates a &#x60;default&#x60; User Type for your
     * org. You may add up to nine additional User Types. &gt; **Note**: New User Types are based on the current default
     * schema template. Modifications to this schema do not automatically propagate to previously created User Types.
     *
     * @param userType
     *            (required)
     *
     * @return UserType
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserType createUserType(CreateUserTypeRequest userType) throws ApiException {
        return this.createUserType(userType, Collections.emptyMap());
    }

    /**
     * Create a User Type Creates a new User Type. Okta automatically creates a &#x60;default&#x60; User Type for your
     * org. You may add up to nine additional User Types. &gt; **Note**: New User Types are based on the current default
     * schema template. Modifications to this schema do not automatically propagate to previously created User Types.
     *
     * @param userType
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return UserType
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserType createUserType(CreateUserTypeRequest userType, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = userType;

        // verify the required parameter 'userType' is set
        if (userType == null) {
            throw new ApiException(400, "Missing the required parameter 'userType' when calling createUserType");
        }

        // create path and map variables
        String localVarPath = "/api/v1/meta/types/user";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<UserType> localVarReturnType = new TypeReference<UserType>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete a User Type Deletes a User Type permanently. &gt; **Note**: You can&#39;t delete the default User Type or
     * a User Type that is currently assigned to users.
     *
     * @param typeId
     *            (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteUserType(String typeId) throws ApiException {
        this.deleteUserType(typeId, Collections.emptyMap());
    }

    /**
     * Delete a User Type Deletes a User Type permanently. &gt; **Note**: You can&#39;t delete the default User Type or
     * a User Type that is currently assigned to users.
     *
     * @param typeId
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteUserType(String typeId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'typeId' is set
        if (typeId == null) {
            throw new ApiException(400, "Missing the required parameter 'typeId' when calling deleteUserType");
        }

        // create path and map variables
        String localVarPath = "/api/v1/meta/types/user/{typeId}".replaceAll("\\{" + "typeId" + "\\}",
                apiClient.escapeString(typeId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve a User Type Retrieves a User Type by ID. Use &#x60;default&#x60; to fetch the default User Type.
     *
     * @param typeId
     *            (required)
     *
     * @return UserType
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserType getUserType(String typeId) throws ApiException {
        return this.getUserType(typeId, Collections.emptyMap());
    }

    /**
     * Retrieve a User Type Retrieves a User Type by ID. Use &#x60;default&#x60; to fetch the default User Type.
     *
     * @param typeId
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return UserType
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserType getUserType(String typeId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'typeId' is set
        if (typeId == null) {
            throw new ApiException(400, "Missing the required parameter 'typeId' when calling getUserType");
        }

        // create path and map variables
        String localVarPath = "/api/v1/meta/types/user/{typeId}".replaceAll("\\{" + "typeId" + "\\}",
                apiClient.escapeString(typeId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<UserType> localVarReturnType = new TypeReference<UserType>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all User Types Lists all User Types in your org
     *
     * @return List&lt;UserType&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<UserType> listUserTypes() throws ApiException {
        return this.listUserTypes(Collections.emptyMap());
    }

    /**
     * List all User Types Lists all User Types in your org
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;UserType&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<UserType> listUserTypes(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/meta/types/user";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<UserType>> localVarReturnType = new TypeReference<List<UserType>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace a User Type Replaces an existing User Type. This operation is a full update. &gt; **Note**: The
     * &#x60;name&#x60; of an existing User Type can&#39;t be changed, but must be part of the request body. You can
     * only replace the &#x60;displayName&#x60; and &#x60;description&#x60; elements.
     *
     * @param typeId
     *            (required)
     * @param userType
     *            (optional)
     *
     * @return UserType
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserType replaceUserType(String typeId, UserTypePutRequest userType) throws ApiException {
        return this.replaceUserType(typeId, userType, Collections.emptyMap());
    }

    /**
     * Replace a User Type Replaces an existing User Type. This operation is a full update. &gt; **Note**: The
     * &#x60;name&#x60; of an existing User Type can&#39;t be changed, but must be part of the request body. You can
     * only replace the &#x60;displayName&#x60; and &#x60;description&#x60; elements.
     *
     * @param typeId
     *            (required)
     * @param userType
     *            (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return UserType
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserType replaceUserType(String typeId, UserTypePutRequest userType, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = userType;

        // verify the required parameter 'typeId' is set
        if (typeId == null) {
            throw new ApiException(400, "Missing the required parameter 'typeId' when calling replaceUserType");
        }

        // create path and map variables
        String localVarPath = "/api/v1/meta/types/user/{typeId}".replaceAll("\\{" + "typeId" + "\\}",
                apiClient.escapeString(typeId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<UserType> localVarReturnType = new TypeReference<UserType>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update a User Type Updates an existing User Type. This operation is a partial update. &gt; **Note**: You can only
     * update the &#x60;displayName&#x60; and &#x60;description&#x60; elements. The &#x60;name&#x60; of an existing User
     * Type can&#39;t be changed.
     *
     * @param typeId
     *            (required)
     * @param userType
     *            (required)
     *
     * @return UserType
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserType updateUserType(String typeId, UserTypePostRequest userType) throws ApiException {
        return this.updateUserType(typeId, userType, Collections.emptyMap());
    }

    /**
     * Update a User Type Updates an existing User Type. This operation is a partial update. &gt; **Note**: You can only
     * update the &#x60;displayName&#x60; and &#x60;description&#x60; elements. The &#x60;name&#x60; of an existing User
     * Type can&#39;t be changed.
     *
     * @param typeId
     *            (required)
     * @param userType
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return UserType
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public UserType updateUserType(String typeId, UserTypePostRequest userType, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = userType;

        // verify the required parameter 'typeId' is set
        if (typeId == null) {
            throw new ApiException(400, "Missing the required parameter 'typeId' when calling updateUserType");
        }

        // verify the required parameter 'userType' is set
        if (userType == null) {
            throw new ApiException(400, "Missing the required parameter 'userType' when calling updateUserType");
        }

        // create path and map variables
        String localVarPath = "/api/v1/meta/types/user/{typeId}".replaceAll("\\{" + "typeId" + "\\}",
                apiClient.escapeString(typeId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<UserType> localVarReturnType = new TypeReference<UserType>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
