/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.EnrollmentActivationRequest;
import com.okta.sdk.resource.model.EnrollmentActivationResponse;
import com.okta.sdk.resource.model.EnrollmentInitializationRequest;
import com.okta.sdk.resource.model.EnrollmentInitializationResponse;
import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.FulfillmentRequest;
import com.okta.sdk.resource.model.PinRequest;
import com.okta.sdk.resource.model.WebAuthnPreregistrationFactor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class WebAuthnPreregistrationApi {

    private ApiClient apiClient;

    public WebAuthnPreregistrationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WebAuthnPreregistrationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Activate a Preregistered WebAuthn Factor Activates a preregistered WebAuthn Factor. As part of this operation,
     * Okta first decrypts and verifies the Factor PIN and enrollment data sent by the fulfillment provider.
     *
     * @param body
     *            Enrollment Activation Request (optional)
     *
     * @return EnrollmentActivationResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public EnrollmentActivationResponse activatePreregistrationEnrollment(EnrollmentActivationRequest body)
            throws ApiException {
        return this.activatePreregistrationEnrollment(body, Collections.emptyMap());
    }

    /**
     * Activate a Preregistered WebAuthn Factor Activates a preregistered WebAuthn Factor. As part of this operation,
     * Okta first decrypts and verifies the Factor PIN and enrollment data sent by the fulfillment provider.
     *
     * @param body
     *            Enrollment Activation Request (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return EnrollmentActivationResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public EnrollmentActivationResponse activatePreregistrationEnrollment(EnrollmentActivationRequest body,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/webauthn-registration/api/v1/activate";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<EnrollmentActivationResponse> localVarReturnType = new TypeReference<EnrollmentActivationResponse>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete a WebAuthn Preregistration Factor Deletes a specific WebAuthn Preregistration Factor for a user
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param authenticatorEnrollmentId
     *            ID for a WebAuthn Preregistration Factor in Okta (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteWebAuthnPreregistrationFactor(String userId, String authenticatorEnrollmentId)
            throws ApiException {
        this.deleteWebAuthnPreregistrationFactor(userId, authenticatorEnrollmentId, Collections.emptyMap());
    }

    /**
     * Delete a WebAuthn Preregistration Factor Deletes a specific WebAuthn Preregistration Factor for a user
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param authenticatorEnrollmentId
     *            ID for a WebAuthn Preregistration Factor in Okta (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteWebAuthnPreregistrationFactor(String userId, String authenticatorEnrollmentId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'userId' when calling deleteWebAuthnPreregistrationFactor");
        }

        // verify the required parameter 'authenticatorEnrollmentId' is set
        if (authenticatorEnrollmentId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authenticatorEnrollmentId' when calling deleteWebAuthnPreregistrationFactor");
        }

        // create path and map variables
        String localVarPath = "/webauthn-registration/api/v1/users/{userId}/enrollments/{authenticatorEnrollmentId}"
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()))
                .replaceAll("\\{" + "authenticatorEnrollmentId" + "\\}",
                        apiClient.escapeString(authenticatorEnrollmentId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Enroll a Preregistered WebAuthn Factor Enrolls a preregistered WebAuthn Factor. This WebAuthn Factor has a longer
     * challenge timeout period to accommodate the fulfillment request process. As part of this operation, Okta
     * generates EC key-pairs used to encrypt the Factor PIN and enrollment data sent by the fulfillment provider.
     *
     * @param body
     *            Enrollment Initialization Request (optional)
     *
     * @return EnrollmentInitializationResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public EnrollmentInitializationResponse enrollPreregistrationEnrollment(EnrollmentInitializationRequest body)
            throws ApiException {
        return this.enrollPreregistrationEnrollment(body, Collections.emptyMap());
    }

    /**
     * Enroll a Preregistered WebAuthn Factor Enrolls a preregistered WebAuthn Factor. This WebAuthn Factor has a longer
     * challenge timeout period to accommodate the fulfillment request process. As part of this operation, Okta
     * generates EC key-pairs used to encrypt the Factor PIN and enrollment data sent by the fulfillment provider.
     *
     * @param body
     *            Enrollment Initialization Request (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return EnrollmentInitializationResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public EnrollmentInitializationResponse enrollPreregistrationEnrollment(EnrollmentInitializationRequest body,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/webauthn-registration/api/v1/enroll";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<EnrollmentInitializationResponse> localVarReturnType = new TypeReference<EnrollmentInitializationResponse>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Generate a Fulfillment Request Generates a fulfillment request by sending a WebAuthn Preregistration event to
     * start the flow. The Okta Workflows WebAuthn preregistration integration uses this to populate the fulfillment
     * request.
     *
     * @param body
     *            Fulfillment Request (optional)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void generateFulfillmentRequest(FulfillmentRequest body) throws ApiException {
        this.generateFulfillmentRequest(body, Collections.emptyMap());
    }

    /**
     * Generate a Fulfillment Request Generates a fulfillment request by sending a WebAuthn Preregistration event to
     * start the flow. The Okta Workflows WebAuthn preregistration integration uses this to populate the fulfillment
     * request.
     *
     * @param body
     *            Fulfillment Request (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void generateFulfillmentRequest(FulfillmentRequest body, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/webauthn-registration/api/v1/initiate-fulfillment-request";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * List all WebAuthn Preregistration Factors Lists all WebAuthn Preregistration Factors for the specified user
     *
     * @param userId
     *            ID of an existing Okta user (required)
     *
     * @return List&lt;WebAuthnPreregistrationFactor&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<WebAuthnPreregistrationFactor> listWebAuthnPreregistrationFactors(String userId) throws ApiException {
        return this.listWebAuthnPreregistrationFactors(userId, Collections.emptyMap());
    }

    /**
     * List all WebAuthn Preregistration Factors Lists all WebAuthn Preregistration Factors for the specified user
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;WebAuthnPreregistrationFactor&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<WebAuthnPreregistrationFactor> listWebAuthnPreregistrationFactors(String userId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'userId' when calling listWebAuthnPreregistrationFactors");
        }

        // create path and map variables
        String localVarPath = "/webauthn-registration/api/v1/users/{userId}/enrollments"
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<WebAuthnPreregistrationFactor>> localVarReturnType = new TypeReference<List<WebAuthnPreregistrationFactor>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Send a PIN to user Sends the decoded PIN for the specified WebAuthn Preregistration Enrollment. PINs are sent to
     * the user&#39;s email. To resend the PIN, call this operation again.
     *
     * @param body
     *            Send PIN Request (optional)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void sendPin(PinRequest body) throws ApiException {
        this.sendPin(body, Collections.emptyMap());
    }

    /**
     * Send a PIN to user Sends the decoded PIN for the specified WebAuthn Preregistration Enrollment. PINs are sent to
     * the user&#39;s email. To resend the PIN, call this operation again.
     *
     * @param body
     *            Send PIN Request (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void sendPin(PinRequest body, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = body;

        // create path and map variables
        String localVarPath = "/webauthn-registration/api/v1/send-pin";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
