package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.APIServiceIntegrationSecretLinks;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * APIServiceIntegrationInstanceSecret
 */
@JsonPropertyOrder({ APIServiceIntegrationInstanceSecret.JSON_PROPERTY_CLIENT_SECRET,
        APIServiceIntegrationInstanceSecret.JSON_PROPERTY_CREATED, APIServiceIntegrationInstanceSecret.JSON_PROPERTY_ID,
        APIServiceIntegrationInstanceSecret.JSON_PROPERTY_LAST_UPDATED,
        APIServiceIntegrationInstanceSecret.JSON_PROPERTY_SECRET_HASH,
        APIServiceIntegrationInstanceSecret.JSON_PROPERTY_STATUS,
        APIServiceIntegrationInstanceSecret.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class APIServiceIntegrationInstanceSecret implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CLIENT_SECRET = "client_secret";
    private String clientSecret;

    public static final String JSON_PROPERTY_CREATED = "created";
    private String created;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private String lastUpdated;

    public static final String JSON_PROPERTY_SECRET_HASH = "secret_hash";
    private String secretHash;

    /**
     * Status of the API Service Integration instance Secret
     */
    public enum StatusEnum {
        ACTIVE("ACTIVE"),

        INACTIVE("INACTIVE"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private APIServiceIntegrationSecretLinks links;

    public APIServiceIntegrationInstanceSecret() {
    }

    /*
     * @JsonCreator public APIServiceIntegrationInstanceSecret(
     *
     * @JsonProperty(JSON_PROPERTY_CLIENT_SECRET) String clientSecret,
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) String created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) String lastUpdated,
     *
     * @JsonProperty(JSON_PROPERTY_SECRET_HASH) String secretHash ) { this(); this.clientSecret = clientSecret;
     * this.created = created; this.id = id; this.lastUpdated = lastUpdated; this.secretHash = secretHash; }
     */

    /**
     * The OAuth 2.0 client secret string. The client secret string is returned in the response of a Secret creation
     * request. In other responses (such as list, activate, or deactivate requests), the client secret is returned as an
     * undisclosed hashed value.
     *
     * @return clientSecret
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "DRUFXGF9XbLnS9k-Sla3x3POBiIxDreBCdZuFs5B", required = true, value = "The OAuth 2.0 client secret string. The client secret string is returned in the response of a Secret creation request. In other responses (such as list, activate, or deactivate requests), the client secret is returned as an undisclosed hashed value.")
    @JsonProperty(JSON_PROPERTY_CLIENT_SECRET)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getClientSecret() {
        return clientSecret;
    }

    /**
     * Timestamp when the API Service Integration instance Secret was created
     *
     * @return created
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "2023-02-21T20:08:24.000Z", required = true, value = "Timestamp when the API Service Integration instance Secret was created")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getCreated() {
        return created;
    }

    /**
     * The ID of the API Service Integration instance Secret
     *
     * @return id
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "ocs2f4zrZbs8nUa7p0g4", required = true, value = "The ID of the API Service Integration instance Secret")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getId() {
        return id;
    }

    /**
     * Timestamp when the API Service Integration instance Secret was updated
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "2023-02-21T20:08:24.000Z", required = true, value = "Timestamp when the API Service Integration instance Secret was updated")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getLastUpdated() {
        return lastUpdated;
    }

    /**
     * OAuth 2.0 client secret string hash
     *
     * @return secretHash
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "yk4SVx4sUWVJVbHt6M-UPA", required = true, value = "OAuth 2.0 client secret string hash")
    @JsonProperty(JSON_PROPERTY_SECRET_HASH)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getSecretHash() {
        return secretHash;
    }

    public APIServiceIntegrationInstanceSecret status(StatusEnum status) {

        this.status = status;
        return this;
    }

    /**
     * Status of the API Service Integration instance Secret
     *
     * @return status
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "ACTIVE", required = true, value = "Status of the API Service Integration instance Secret")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public StatusEnum getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public APIServiceIntegrationInstanceSecret links(APIServiceIntegrationSecretLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public APIServiceIntegrationSecretLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setLinks(APIServiceIntegrationSecretLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        APIServiceIntegrationInstanceSecret apIServiceIntegrationInstanceSecret = (APIServiceIntegrationInstanceSecret) o;
        return Objects.equals(this.clientSecret, apIServiceIntegrationInstanceSecret.clientSecret)
                && Objects.equals(this.created, apIServiceIntegrationInstanceSecret.created)
                && Objects.equals(this.id, apIServiceIntegrationInstanceSecret.id)
                && Objects.equals(this.lastUpdated, apIServiceIntegrationInstanceSecret.lastUpdated)
                && Objects.equals(this.secretHash, apIServiceIntegrationInstanceSecret.secretHash)
                && Objects.equals(this.status, apIServiceIntegrationInstanceSecret.status)
                && Objects.equals(this.links, apIServiceIntegrationInstanceSecret.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(clientSecret, created, id, lastUpdated, secretHash, status, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class APIServiceIntegrationInstanceSecret {\n");
        sb.append("    clientSecret: ").append(toIndentedString(clientSecret)).append("\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    secretHash: ").append(toIndentedString(secretHash)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
