package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AppUserPasswordCredential;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies a user&#39;s credentials for the app. This parameter can be omitted for apps with [sign-on
 * mode](/openapi/okta-management/management/tag/Application/#tag/Application/operation/getApplication!c&#x3D;200&amp;path&#x3D;0/signOnMode&amp;t&#x3D;response)
 * (&#x60;signOnMode&#x60;) or [authentication
 * schemes](/openapi/okta-management/management/tag/Application/#tag/Application/operation/getApplication!c&#x3D;200&amp;path&#x3D;0/credentials/scheme&amp;t&#x3D;response)
 * (&#x60;credentials.scheme&#x60;) that don&#39;t require credentials.
 */
@ApiModel(description = "Specifies a user's credentials for the app. This parameter can be omitted for apps with [sign-on mode](/openapi/okta-management/management/tag/Application/#tag/Application/operation/getApplication!c=200&path=0/signOnMode&t=response) (`signOnMode`) or [authentication schemes](/openapi/okta-management/management/tag/Application/#tag/Application/operation/getApplication!c=200&path=0/credentials/scheme&t=response) (`credentials.scheme`) that don't require credentials. ")
@JsonPropertyOrder({ AppUserCredentials.JSON_PROPERTY_PASSWORD, AppUserCredentials.JSON_PROPERTY_USER_NAME })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class AppUserCredentials implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_PASSWORD = "password";
    private AppUserPasswordCredential password;

    public static final String JSON_PROPERTY_USER_NAME = "userName";
    private String userName;

    public AppUserCredentials() {
    }

    public AppUserCredentials password(AppUserPasswordCredential password) {

        this.password = password;
        return this;
    }

    /**
     * Get password
     *
     * @return password
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PASSWORD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AppUserPasswordCredential getPassword() {
        return password;
    }

    @JsonProperty(JSON_PROPERTY_PASSWORD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPassword(AppUserPasswordCredential password) {
        this.password = password;
    }

    public AppUserCredentials userName(String userName) {

        this.userName = userName;
        return this;
    }

    /**
     * The user&#39;s username in the app &gt; **Note:** The
     * [userNameTemplate](/openapi/okta-management/management/tag/Application/#tag/Application/operation/createApplication!path&#x3D;0/credentials/userNameTemplate&amp;t&#x3D;request)
     * in the Application object defines the default username generated when a user is assigned to that app. &gt; If you
     * attempt to assign a username or password to an app with an incompatible [authentication
     * scheme](/openapi/okta-management/management/tag/Application/#tag/Application/operation/createApplication!path&#x3D;0/credentials/scheme&amp;t&#x3D;request),
     * the following error is returned: &gt; \&quot;Credentials should not be set on this resource based on the
     * scheme.\&quot;
     *
     * @return userName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "testuser@example.com", value = "The user's username in the app  > **Note:** The [userNameTemplate](/openapi/okta-management/management/tag/Application/#tag/Application/operation/createApplication!path=0/credentials/userNameTemplate&t=request) in the Application object defines the default username generated when a user is assigned to that app. > If you attempt to assign a username or password to an app with an incompatible [authentication scheme](/openapi/okta-management/management/tag/Application/#tag/Application/operation/createApplication!path=0/credentials/scheme&t=request), the following error is returned: > \"Credentials should not be set on this resource based on the scheme.\"")
    @JsonProperty(JSON_PROPERTY_USER_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUserName() {
        return userName;
    }

    @JsonProperty(JSON_PROPERTY_USER_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AppUserCredentials appUserCredentials = (AppUserCredentials) o;
        return Objects.equals(this.password, appUserCredentials.password)
                && Objects.equals(this.userName, appUserCredentials.userName);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(password, userName);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppUserCredentials {\n");
        sb.append("    password: ").append(toIndentedString(password)).append("\n");
        sb.append("    userName: ").append(toIndentedString(userName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
