package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * The synchronization state for the Application User. The Application User&#39;s &#x60;syncState&#x60; depends on
 * whether the &#x60;PROFILE_MASTERING&#x60; feature is enabled for the app. &gt; **Note:** User provisioning currently
 * must be configured through the Admin Console.
 */
public enum AppUserSyncState {

    DISABLED("DISABLED"),

    ERROR("ERROR"),

    OUT_OF_SYNC("OUT_OF_SYNC"),

    SYNCHRONIZED("SYNCHRONIZED"),

    SYNCING("SYNCING"),

    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    AppUserSyncState(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static AppUserSyncState fromValue(String value) {
        for (AppUserSyncState b : AppUserSyncState.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    /**
     * Convert the instance into URL query string.
     *
     * @param prefix
     *            prefix of the query string
     *
     * @return URL query string
     */
    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }

        return String.format("%s=%s", prefix, this.toString().toString());
    }
}
