package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Key name of the feature | Feature name | Description | | --------- | ------------- | | USER_PROVISIONING | User
 * profiles are pushed from Okta to the third-party app. Represents the **To App** provisioning feature setting in the
 * Admin Console. | | INBOUND_PROVISIONING | User profiles are imported from the third-party app into Okta. This feature
 * represents the **To Okta** provisioning feature setting in the Admin Console. | Select the feature:
 */
public enum ApplicationFeatureType {

    USER_PROVISIONING("USER_PROVISIONING"),

    USER_PROVISIONING2("USER_PROVISIONING"),

    INBOUND_PROVISIONING("INBOUND_PROVISIONING"),

    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    ApplicationFeatureType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static ApplicationFeatureType fromValue(String value) {
        for (ApplicationFeatureType b : ApplicationFeatureType.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    /**
     * Convert the instance into URL query string.
     *
     * @param prefix
     *            prefix of the query string
     *
     * @return URL query string
     */
    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }

        return String.format("%s=%s", prefix, this.toString().toString());
    }
}
