package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.CustomRoleAssignmentSchema;
import com.okta.sdk.resource.model.StandardRoleAssignmentSchema;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * AssignRoleToUserRequest
 */
@JsonPropertyOrder({ AssignRoleToUserRequest.JSON_PROPERTY_TYPE, AssignRoleToUserRequest.JSON_PROPERTY_RESOURCE_SET,
        AssignRoleToUserRequest.JSON_PROPERTY_ROLE })
@JsonTypeName("assignRoleToUser_request")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class AssignRoleToUserRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public static final String JSON_PROPERTY_RESOURCE_SET = "resource-set";
    private String resourceSet;

    public static final String JSON_PROPERTY_ROLE = "role";
    private String role;

    public AssignRoleToUserRequest() {
    }

    public AssignRoleToUserRequest type(String type) {

        this.type = type;
        return this;
    }

    /**
     * Specify the standard or IAM-based role type. See [standard
     * roles](/openapi/okta-management/guides/roles/#standard-roles).
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Specify the standard or IAM-based role type. See [standard roles](/openapi/okta-management/guides/roles/#standard-roles).")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public AssignRoleToUserRequest resourceSet(String resourceSet) {

        this.resourceSet = resourceSet;
        return this;
    }

    /**
     * Resource Set ID
     *
     * @return resourceSet
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Resource Set ID")
    @JsonProperty(JSON_PROPERTY_RESOURCE_SET)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getResourceSet() {
        return resourceSet;
    }

    @JsonProperty(JSON_PROPERTY_RESOURCE_SET)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setResourceSet(String resourceSet) {
        this.resourceSet = resourceSet;
    }

    public AssignRoleToUserRequest role(String role) {

        this.role = role;
        return this;
    }

    /**
     * Custom Role ID
     *
     * @return role
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Custom Role ID")
    @JsonProperty(JSON_PROPERTY_ROLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getRole() {
        return role;
    }

    @JsonProperty(JSON_PROPERTY_ROLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRole(String role) {
        this.role = role;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AssignRoleToUserRequest assignRoleToUserRequest = (AssignRoleToUserRequest) o;
        return Objects.equals(this.type, assignRoleToUserRequest.type)
                && Objects.equals(this.resourceSet, assignRoleToUserRequest.resourceSet)
                && Objects.equals(this.role, assignRoleToUserRequest.role);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(type, resourceSet, role);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssignRoleToUserRequest {\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    resourceSet: ").append(toIndentedString(resourceSet)).append("\n");
        sb.append("    role: ").append(toIndentedString(role)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
