package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AccessPolicyConstraints;
import com.okta.sdk.resource.model.AssuranceMethodFactorMode;
import com.okta.sdk.resource.model.PolicyRuleVerificationMethodType;
import com.okta.sdk.resource.model.VerificationMethod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * AssuranceMethod
 */
@JsonPropertyOrder({ AssuranceMethod.JSON_PROPERTY_CONSTRAINTS, AssuranceMethod.JSON_PROPERTY_FACTOR_MODE,
        AssuranceMethod.JSON_PROPERTY_INACTIVITY_PERIOD, AssuranceMethod.JSON_PROPERTY_REAUTHENTICATE_IN })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "type", visible = true, defaultImpl = AssuranceMethod.class)

public class AssuranceMethod extends VerificationMethod implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CONSTRAINTS = "constraints";
    private List<AccessPolicyConstraints> constraints = null;

    public static final String JSON_PROPERTY_FACTOR_MODE = "factorMode";
    private AssuranceMethodFactorMode factorMode;

    public static final String JSON_PROPERTY_INACTIVITY_PERIOD = "inactivityPeriod";
    private String inactivityPeriod;

    public static final String JSON_PROPERTY_REAUTHENTICATE_IN = "reauthenticateIn";
    private String reauthenticateIn;

    public AssuranceMethod() {
    }

    public AssuranceMethod constraints(List<AccessPolicyConstraints> constraints) {

        this.constraints = constraints;
        return this;
    }

    public AssuranceMethod addconstraintsItem(AccessPolicyConstraints constraintsItem) {
        if (this.constraints == null) {
            this.constraints = new ArrayList<>();
        }
        this.constraints.add(constraintsItem);
        return this;
    }

    /**
     * Get constraints
     *
     * @return constraints
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CONSTRAINTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<AccessPolicyConstraints> getConstraints() {
        return constraints;
    }

    @JsonProperty(JSON_PROPERTY_CONSTRAINTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setConstraints(List<AccessPolicyConstraints> constraints) {
        this.constraints = constraints;
    }

    public AssuranceMethod factorMode(AssuranceMethodFactorMode factorMode) {

        this.factorMode = factorMode;
        return this;
    }

    /**
     * Get factorMode
     *
     * @return factorMode
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_FACTOR_MODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AssuranceMethodFactorMode getFactorMode() {
        return factorMode;
    }

    @JsonProperty(JSON_PROPERTY_FACTOR_MODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFactorMode(AssuranceMethodFactorMode factorMode) {
        this.factorMode = factorMode;
    }

    public AssuranceMethod inactivityPeriod(String inactivityPeriod) {

        this.inactivityPeriod = inactivityPeriod;
        return this;
    }

    /**
     * The inactivity duration after which the user must re-authenticate. Use the ISO 8601 period format (for example,
     * PT2H).
     *
     * @return inactivityPeriod
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The inactivity duration after which the user must re-authenticate. Use the ISO 8601 period format (for example, PT2H).")
    @JsonProperty(JSON_PROPERTY_INACTIVITY_PERIOD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getInactivityPeriod() {
        return inactivityPeriod;
    }

    @JsonProperty(JSON_PROPERTY_INACTIVITY_PERIOD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setInactivityPeriod(String inactivityPeriod) {
        this.inactivityPeriod = inactivityPeriod;
    }

    public AssuranceMethod reauthenticateIn(String reauthenticateIn) {

        this.reauthenticateIn = reauthenticateIn;
        return this;
    }

    /**
     * The duration after which the user must re-authenticate, regardless of user activity. Keep in mind that the
     * re-authentication intervals for constraints take precedent over this value. Use the ISO 8601 period format for
     * recurring time intervals (for example, PT2H, PT0S, PT43800H, and so on).
     *
     * @return reauthenticateIn
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The duration after which the user must re-authenticate, regardless of user activity. Keep in mind that the re-authentication intervals for constraints take precedent over this value. Use the ISO 8601 period format for recurring time intervals (for example, PT2H, PT0S, PT43800H, and so on).")
    @JsonProperty(JSON_PROPERTY_REAUTHENTICATE_IN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getReauthenticateIn() {
        return reauthenticateIn;
    }

    @JsonProperty(JSON_PROPERTY_REAUTHENTICATE_IN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setReauthenticateIn(String reauthenticateIn) {
        this.reauthenticateIn = reauthenticateIn;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AssuranceMethod assuranceMethod = (AssuranceMethod) o;
        return Objects.equals(this.constraints, assuranceMethod.constraints)
                && Objects.equals(this.factorMode, assuranceMethod.factorMode)
                && Objects.equals(this.inactivityPeriod, assuranceMethod.inactivityPeriod)
                && Objects.equals(this.reauthenticateIn, assuranceMethod.reauthenticateIn);
        // && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(constraints, factorMode, inactivityPeriod, reauthenticateIn, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssuranceMethod {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    constraints: ").append(toIndentedString(constraints)).append("\n");
        sb.append("    factorMode: ").append(toIndentedString(factorMode)).append("\n");
        sb.append("    inactivityPeriod: ").append(toIndentedString(inactivityPeriod)).append("\n");
        sb.append("    reauthenticateIn: ").append(toIndentedString(reauthenticateIn)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
