package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AuthenticatorEnrollmentPolicyAuthenticatorSettingsConstraints;
import com.okta.sdk.resource.model.AuthenticatorEnrollmentPolicyAuthenticatorSettingsEnroll;
import com.okta.sdk.resource.model.AuthenticatorEnrollmentPolicyAuthenticatorType;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * AuthenticatorEnrollmentPolicyAuthenticatorSettings
 */
@JsonPropertyOrder({ AuthenticatorEnrollmentPolicyAuthenticatorSettings.JSON_PROPERTY_CONSTRAINTS,
        AuthenticatorEnrollmentPolicyAuthenticatorSettings.JSON_PROPERTY_ENROLL,
        AuthenticatorEnrollmentPolicyAuthenticatorSettings.JSON_PROPERTY_KEY })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class AuthenticatorEnrollmentPolicyAuthenticatorSettings implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CONSTRAINTS = "constraints";
    private JsonNullable<AuthenticatorEnrollmentPolicyAuthenticatorSettingsConstraints> constraints = JsonNullable
            .<AuthenticatorEnrollmentPolicyAuthenticatorSettingsConstraints> undefined();

    public static final String JSON_PROPERTY_ENROLL = "enroll";
    private AuthenticatorEnrollmentPolicyAuthenticatorSettingsEnroll enroll;

    public static final String JSON_PROPERTY_KEY = "key";
    private AuthenticatorEnrollmentPolicyAuthenticatorType key;

    public AuthenticatorEnrollmentPolicyAuthenticatorSettings() {
    }

    public AuthenticatorEnrollmentPolicyAuthenticatorSettings constraints(
            AuthenticatorEnrollmentPolicyAuthenticatorSettingsConstraints constraints) {
        this.constraints = JsonNullable.<AuthenticatorEnrollmentPolicyAuthenticatorSettingsConstraints> of(constraints);

        return this;
    }

    /**
     * Get constraints
     *
     * @return constraints
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonIgnore

    public AuthenticatorEnrollmentPolicyAuthenticatorSettingsConstraints getConstraints() {
        return constraints.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_CONSTRAINTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<AuthenticatorEnrollmentPolicyAuthenticatorSettingsConstraints> getConstraints_JsonNullable() {
        return constraints;
    }

    @JsonProperty(JSON_PROPERTY_CONSTRAINTS)
    public void setConstraints_JsonNullable(
            JsonNullable<AuthenticatorEnrollmentPolicyAuthenticatorSettingsConstraints> constraints) {
        this.constraints = constraints;
    }

    public void setConstraints(AuthenticatorEnrollmentPolicyAuthenticatorSettingsConstraints constraints) {
        this.constraints = JsonNullable.<AuthenticatorEnrollmentPolicyAuthenticatorSettingsConstraints> of(constraints);
    }

    public AuthenticatorEnrollmentPolicyAuthenticatorSettings enroll(
            AuthenticatorEnrollmentPolicyAuthenticatorSettingsEnroll enroll) {

        this.enroll = enroll;
        return this;
    }

    /**
     * Get enroll
     *
     * @return enroll
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ENROLL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AuthenticatorEnrollmentPolicyAuthenticatorSettingsEnroll getEnroll() {
        return enroll;
    }

    @JsonProperty(JSON_PROPERTY_ENROLL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setEnroll(AuthenticatorEnrollmentPolicyAuthenticatorSettingsEnroll enroll) {
        this.enroll = enroll;
    }

    public AuthenticatorEnrollmentPolicyAuthenticatorSettings key(AuthenticatorEnrollmentPolicyAuthenticatorType key) {

        this.key = key;
        return this;
    }

    /**
     * Get key
     *
     * @return key
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_KEY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AuthenticatorEnrollmentPolicyAuthenticatorType getKey() {
        return key;
    }

    @JsonProperty(JSON_PROPERTY_KEY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setKey(AuthenticatorEnrollmentPolicyAuthenticatorType key) {
        this.key = key;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorEnrollmentPolicyAuthenticatorSettings authenticatorEnrollmentPolicyAuthenticatorSettings = (AuthenticatorEnrollmentPolicyAuthenticatorSettings) o;
        return equalsNullable(this.constraints, authenticatorEnrollmentPolicyAuthenticatorSettings.constraints)
                && Objects.equals(this.enroll, authenticatorEnrollmentPolicyAuthenticatorSettings.enroll)
                && Objects.equals(this.key, authenticatorEnrollmentPolicyAuthenticatorSettings.key);
        // ;
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b
                || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
    }

    @Override
    public int hashCode() {
        return Objects.hash(hashCodeNullable(constraints), enroll, key);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[] { a.get() }) : 31;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticatorEnrollmentPolicyAuthenticatorSettings {\n");
        sb.append("    constraints: ").append(toIndentedString(constraints)).append("\n");
        sb.append("    enroll: ").append(toIndentedString(enroll)).append("\n");
        sb.append("    key: ").append(toIndentedString(key)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
