package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AuthenticatorMethodAlgorithm;
import com.okta.sdk.resource.model.PushMethodKeyProtection;
import com.okta.sdk.resource.model.ShowSignInWithOV;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * AuthenticatorMethodSignedNonceAllOfSettings
 */
@JsonPropertyOrder({ AuthenticatorMethodSignedNonceAllOfSettings.JSON_PROPERTY_ALGORITHMS,
        AuthenticatorMethodSignedNonceAllOfSettings.JSON_PROPERTY_KEY_PROTECTION,
        AuthenticatorMethodSignedNonceAllOfSettings.JSON_PROPERTY_SHOW_SIGN_IN_WITH_O_V })
@JsonTypeName("AuthenticatorMethodSignedNonce_allOf_settings")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class AuthenticatorMethodSignedNonceAllOfSettings implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ALGORITHMS = "algorithms";
    private List<AuthenticatorMethodAlgorithm> algorithms = null;

    public static final String JSON_PROPERTY_KEY_PROTECTION = "keyProtection";
    private PushMethodKeyProtection keyProtection;

    public static final String JSON_PROPERTY_SHOW_SIGN_IN_WITH_O_V = "showSignInWithOV";
    private ShowSignInWithOV showSignInWithOV;

    public AuthenticatorMethodSignedNonceAllOfSettings() {
    }

    public AuthenticatorMethodSignedNonceAllOfSettings algorithms(List<AuthenticatorMethodAlgorithm> algorithms) {

        this.algorithms = algorithms;
        return this;
    }

    public AuthenticatorMethodSignedNonceAllOfSettings addalgorithmsItem(AuthenticatorMethodAlgorithm algorithmsItem) {
        if (this.algorithms == null) {
            this.algorithms = new ArrayList<>();
        }
        this.algorithms.add(algorithmsItem);
        return this;
    }

    /**
     * Get algorithms
     *
     * @return algorithms
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ALGORITHMS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<AuthenticatorMethodAlgorithm> getAlgorithms() {
        return algorithms;
    }

    @JsonProperty(JSON_PROPERTY_ALGORITHMS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAlgorithms(List<AuthenticatorMethodAlgorithm> algorithms) {
        this.algorithms = algorithms;
    }

    public AuthenticatorMethodSignedNonceAllOfSettings keyProtection(PushMethodKeyProtection keyProtection) {

        this.keyProtection = keyProtection;
        return this;
    }

    /**
     * Get keyProtection
     *
     * @return keyProtection
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_KEY_PROTECTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PushMethodKeyProtection getKeyProtection() {
        return keyProtection;
    }

    @JsonProperty(JSON_PROPERTY_KEY_PROTECTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setKeyProtection(PushMethodKeyProtection keyProtection) {
        this.keyProtection = keyProtection;
    }

    public AuthenticatorMethodSignedNonceAllOfSettings showSignInWithOV(ShowSignInWithOV showSignInWithOV) {

        this.showSignInWithOV = showSignInWithOV;
        return this;
    }

    /**
     * Get showSignInWithOV
     *
     * @return showSignInWithOV
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SHOW_SIGN_IN_WITH_O_V)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ShowSignInWithOV getShowSignInWithOV() {
        return showSignInWithOV;
    }

    @JsonProperty(JSON_PROPERTY_SHOW_SIGN_IN_WITH_O_V)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setShowSignInWithOV(ShowSignInWithOV showSignInWithOV) {
        this.showSignInWithOV = showSignInWithOV;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorMethodSignedNonceAllOfSettings authenticatorMethodSignedNonceAllOfSettings = (AuthenticatorMethodSignedNonceAllOfSettings) o;
        return Objects.equals(this.algorithms, authenticatorMethodSignedNonceAllOfSettings.algorithms)
                && Objects.equals(this.keyProtection, authenticatorMethodSignedNonceAllOfSettings.keyProtection)
                && Objects.equals(this.showSignInWithOV, authenticatorMethodSignedNonceAllOfSettings.showSignInWithOV);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(algorithms, keyProtection, showSignInWithOV);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticatorMethodSignedNonceAllOfSettings {\n");
        sb.append("    algorithms: ").append(toIndentedString(algorithms)).append("\n");
        sb.append("    keyProtection: ").append(toIndentedString(keyProtection)).append("\n");
        sb.append("    showSignInWithOV: ").append(toIndentedString(showSignInWithOV)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
