package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AuthServerLinks;
import com.okta.sdk.resource.model.AuthorizationServerCredentials;
import com.okta.sdk.resource.model.LifecycleStatus;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * AuthorizationServer
 */
@JsonPropertyOrder({ AuthorizationServer.JSON_PROPERTY_AUDIENCES, AuthorizationServer.JSON_PROPERTY_CREATED,
        AuthorizationServer.JSON_PROPERTY_CREDENTIALS, AuthorizationServer.JSON_PROPERTY_DESCRIPTION,
        AuthorizationServer.JSON_PROPERTY_ID, AuthorizationServer.JSON_PROPERTY_ISSUER,
        AuthorizationServer.JSON_PROPERTY_ISSUER_MODE, AuthorizationServer.JSON_PROPERTY_LAST_UPDATED,
        AuthorizationServer.JSON_PROPERTY_NAME, AuthorizationServer.JSON_PROPERTY_STATUS,
        AuthorizationServer.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class AuthorizationServer implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_AUDIENCES = "audiences";
    private List<String> audiences = null;

    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;

    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private AuthorizationServerCredentials credentials;

    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_ISSUER = "issuer";
    private String issuer;

    public static final String JSON_PROPERTY_ISSUER_MODE = "issuerMode";
    private String issuerMode;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_STATUS = "status";
    private LifecycleStatus status;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private AuthServerLinks links;

    public AuthorizationServer() {
    }

    /*
     * @JsonCreator public AuthorizationServer(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated ) { this(); this.created = created; this.id
     * = id; this.lastUpdated = lastUpdated; }
     */

    public AuthorizationServer audiences(List<String> audiences) {

        this.audiences = audiences;
        return this;
    }

    public AuthorizationServer addaudiencesItem(String audiencesItem) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<>();
        }
        this.audiences.add(audiencesItem);
        return this;
    }

    /**
     * The recipients that the tokens are intended for. This becomes the &#x60;aud&#x60; claim in an access token. Okta
     * currently supports only one audience.
     *
     * @return audiences
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The recipients that the tokens are intended for. This becomes the `aud` claim in an access token. Okta currently supports only one audience.")
    @JsonProperty(JSON_PROPERTY_AUDIENCES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getAudiences() {
        return audiences;
    }

    @JsonProperty(JSON_PROPERTY_AUDIENCES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAudiences(List<String> audiences) {
        this.audiences = audiences;
    }

    /**
     * Get created
     *
     * @return created
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }

    public AuthorizationServer credentials(AuthorizationServerCredentials credentials) {

        this.credentials = credentials;
        return this;
    }

    /**
     * Get credentials
     *
     * @return credentials
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CREDENTIALS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AuthorizationServerCredentials getCredentials() {
        return credentials;
    }

    @JsonProperty(JSON_PROPERTY_CREDENTIALS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCredentials(AuthorizationServerCredentials credentials) {
        this.credentials = credentials;
    }

    public AuthorizationServer description(String description) {

        this.description = description;
        return this;
    }

    /**
     * The description of the custom authorization server
     *
     * @return description
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The description of the custom authorization server")
    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDescription() {
        return description;
    }

    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * The ID of the custom authorization server
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The ID of the custom authorization server")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    public AuthorizationServer issuer(String issuer) {

        this.issuer = issuer;
        return this;
    }

    /**
     * The complete URL for the custom authorization server. This becomes the &#x60;iss&#x60; claim in an access token.
     *
     * @return issuer
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The complete URL for the custom authorization server. This becomes the `iss` claim in an access token.")
    @JsonProperty(JSON_PROPERTY_ISSUER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getIssuer() {
        return issuer;
    }

    @JsonProperty(JSON_PROPERTY_ISSUER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public AuthorizationServer issuerMode(String issuerMode) {

        this.issuerMode = issuerMode;
        return this;
    }

    /**
     * Indicates which value is specified in the issuer of the tokens that a custom authorization server returns: the
     * Okta org domain URL or a custom domain URL. &#x60;issuerMode&#x60; is visible if you have a custom URL domain
     * configured or the Dynamic Issuer Mode feature enabled. If you have a custom URL domain configured, you can set a
     * custom domain URL in a custom authorization server, and this property is returned in the appropriate responses.
     * When set to &#x60;ORG_URL&#x60;, then in responses, &#x60;issuer&#x60; is the Okta org domain URL:
     * &#x60;https://${yourOktaDomain}&#x60;. When set to &#x60;CUSTOM_URL&#x60;, then in responses, &#x60;issuer&#x60;
     * is the custom domain URL configured in the administration user interface. When set to &#x60;DYNAMIC&#x60;, then
     * in responses, &#x60;issuer&#x60; is the custom domain URL if the OAuth 2.0 request was sent to the custom domain,
     * or is the Okta org&#39;s domain URL if the OAuth 2.0 request was sent to the original Okta org domain. After you
     * configure a custom URL domain, all new custom authorization servers use &#x60;CUSTOM_URL&#x60; by default. If the
     * Dynamic Issuer Mode feature is enabled, then all new custom authorization servers use &#x60;DYNAMIC&#x60; by
     * default. All existing custom authorization servers continue to use the original value until they&#39;re changed
     * using the Admin Console or the API. This way, existing integrations with the client and resource server continue
     * to work after the feature is enabled.
     *
     * @return issuerMode
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates which value is specified in the issuer of the tokens that a custom authorization server returns: the Okta org domain URL or a custom domain URL.  `issuerMode` is visible if you have a custom URL domain configured or the Dynamic Issuer Mode feature enabled. If you have a custom URL domain configured, you can set a custom domain URL in a custom authorization server, and this property is returned in the appropriate responses.  When set to `ORG_URL`, then in responses, `issuer` is the Okta org domain URL: `https://${yourOktaDomain}`.  When set to `CUSTOM_URL`, then in responses, `issuer` is the custom domain URL configured in the administration user interface.  When set to `DYNAMIC`, then in responses, `issuer` is the custom domain URL if the OAuth 2.0 request was sent to the custom domain, or is the Okta org's domain URL if the OAuth 2.0 request was sent to the original Okta org domain.  After you configure a custom URL domain, all new custom authorization servers use `CUSTOM_URL` by default. If the Dynamic Issuer Mode feature is enabled, then all new custom authorization servers use `DYNAMIC` by default. All existing custom authorization servers continue to use the original value until they're changed using the Admin Console or the API. This way, existing integrations with the client and resource server continue to work after the feature is enabled.")
    @JsonProperty(JSON_PROPERTY_ISSUER_MODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getIssuerMode() {
        return issuerMode;
    }

    @JsonProperty(JSON_PROPERTY_ISSUER_MODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setIssuerMode(String issuerMode) {
        this.issuerMode = issuerMode;
    }

    /**
     * Get lastUpdated
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }

    public AuthorizationServer name(String name) {

        this.name = name;
        return this;
    }

    /**
     * The name of the custom authorization server
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The name of the custom authorization server")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public AuthorizationServer status(LifecycleStatus status) {

        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LifecycleStatus getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(LifecycleStatus status) {
        this.status = status;
    }

    public AuthorizationServer links(AuthServerLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AuthServerLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(AuthServerLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AuthorizationServer authorizationServer = (AuthorizationServer) o;
        return Objects.equals(this.audiences, authorizationServer.audiences)
                && Objects.equals(this.created, authorizationServer.created)
                && Objects.equals(this.credentials, authorizationServer.credentials)
                && Objects.equals(this.description, authorizationServer.description)
                && Objects.equals(this.id, authorizationServer.id)
                && Objects.equals(this.issuer, authorizationServer.issuer)
                && Objects.equals(this.issuerMode, authorizationServer.issuerMode)
                && Objects.equals(this.lastUpdated, authorizationServer.lastUpdated)
                && Objects.equals(this.name, authorizationServer.name)
                && Objects.equals(this.status, authorizationServer.status)
                && Objects.equals(this.links, authorizationServer.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(audiences, created, credentials, description, id, issuer, issuerMode, lastUpdated, name,
                status, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthorizationServer {\n");
        sb.append("    audiences: ").append(toIndentedString(audiences)).append("\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    credentials: ").append(toIndentedString(credentials)).append("\n");
        sb.append("    description: ").append(toIndentedString(description)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    issuer: ").append(toIndentedString(issuer)).append("\n");
        sb.append("    issuerMode: ").append(toIndentedString(issuerMode)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
