package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * The destination AWS region where your event source is located
 */
public enum AwsRegion {

    AP_NORTHEAST_1("ap-northeast-1"),

    AP_NORTHEAST_2("ap-northeast-2"),

    AP_NORTHEAST_3("ap-northeast-3"),

    AP_SOUTH_1("ap-south-1"),

    AP_SOUTHEAST_1("ap-southeast-1"),

    AP_SOUTHEAST_2("ap-southeast-2"),

    CA_CENTRAL_1("ca-central-1"),

    EU_CENTRAL_1("eu-central-1"),

    EU_NORTH_1("eu-north-1"),

    EU_WEST_1("eu-west-1"),

    EU_WEST_2("eu-west-2"),

    EU_WEST_3("eu-west-3"),

    SA_EAST_1("sa-east-1"),

    US_EAST_1("us-east-1"),

    US_EAST_2("us-east-2"),

    US_WEST_1("us-west-1"),

    US_WEST_2("us-west-2"),

    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    AwsRegion(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static AwsRegion fromValue(String value) {
        for (AwsRegion b : AwsRegion.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    /**
     * Convert the instance into URL query string.
     *
     * @param prefix
     *            prefix of the query string
     *
     * @return URL query string
     */
    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }

        return String.format("%s=%s", prefix, this.toString().toString());
    }
}
