package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.BaseContextUserLinks;
import com.okta.sdk.resource.model.BaseContextUserProfile;
import java.time.OffsetDateTime;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Identifies the Okta user that the token was generated to authenticate and provides details of their Okta user profile
 */
@ApiModel(description = "Identifies the Okta user that the token was generated to authenticate and provides details of their Okta user profile")
@JsonPropertyOrder({ BaseContextUser.JSON_PROPERTY_ID, BaseContextUser.JSON_PROPERTY_PASSWORD_CHANGED,
        BaseContextUser.JSON_PROPERTY_PROFILE, BaseContextUser.JSON_PROPERTY_LINKS })
@JsonTypeName("BaseContext_user")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class BaseContextUser implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_PASSWORD_CHANGED = "passwordChanged";
    private OffsetDateTime passwordChanged;

    public static final String JSON_PROPERTY_PROFILE = "profile";
    private BaseContextUserProfile profile;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private BaseContextUserLinks links;

    public BaseContextUser() {
    }

    public BaseContextUser id(String id) {

        this.id = id;
        return this;
    }

    /**
     * The unique identifier for the user
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "00uq8tMo3zV0OfJON0g3", value = "The unique identifier for the user")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public BaseContextUser passwordChanged(OffsetDateTime passwordChanged) {

        this.passwordChanged = passwordChanged;
        return this;
    }

    /**
     * The timestamp when the user&#39;s password was last updated
     *
     * @return passwordChanged
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2018-09-11T23:19:12Z", value = "The timestamp when the user's password was last updated")
    @JsonProperty(JSON_PROPERTY_PASSWORD_CHANGED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getPasswordChanged() {
        return passwordChanged;
    }

    @JsonProperty(JSON_PROPERTY_PASSWORD_CHANGED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPasswordChanged(OffsetDateTime passwordChanged) {
        this.passwordChanged = passwordChanged;
    }

    public BaseContextUser profile(BaseContextUserProfile profile) {

        this.profile = profile;
        return this;
    }

    /**
     * Get profile
     *
     * @return profile
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public BaseContextUserProfile getProfile() {
        return profile;
    }

    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProfile(BaseContextUserProfile profile) {
        this.profile = profile;
    }

    public BaseContextUser links(BaseContextUserLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public BaseContextUserLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(BaseContextUserLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BaseContextUser baseContextUser = (BaseContextUser) o;
        return Objects.equals(this.id, baseContextUser.id)
                && Objects.equals(this.passwordChanged, baseContextUser.passwordChanged)
                && Objects.equals(this.profile, baseContextUser.profile)
                && Objects.equals(this.links, baseContextUser.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, passwordChanged, profile, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BaseContextUser {\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    passwordChanged: ").append(toIndentedString(passwordChanged)).append("\n");
        sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
