package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.HrefObject;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies link relations (see [Web Linking](https://www.rfc-editor.org/rfc/rfc8288)) available for the current status
 * of the user. These links are used to discover what groups the user is a part of and what factors they have enrolled.
 */
@ApiModel(description = "Specifies link relations (see [Web Linking](https://www.rfc-editor.org/rfc/rfc8288)) available for the current status of the user. These links are used to discover what groups the user is a part of and what factors they have enrolled.")
@JsonPropertyOrder({ BaseContextUserLinks.JSON_PROPERTY_GROUPS, BaseContextUserLinks.JSON_PROPERTY_FACTORS })
@JsonTypeName("BaseContext_user__links")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class BaseContextUserLinks implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_GROUPS = "groups";
    private HrefObject groups;

    public static final String JSON_PROPERTY_FACTORS = "factors";
    private HrefObject factors;

    public BaseContextUserLinks() {
    }

    public BaseContextUserLinks groups(HrefObject groups) {

        this.groups = groups;
        return this;
    }

    /**
     * URL to retrieve the individual user&#39;s group memberships
     *
     * @return groups
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "URL to retrieve the individual user's group memberships")
    @JsonProperty(JSON_PROPERTY_GROUPS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObject getGroups() {
        return groups;
    }

    @JsonProperty(JSON_PROPERTY_GROUPS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setGroups(HrefObject groups) {
        this.groups = groups;
    }

    public BaseContextUserLinks factors(HrefObject factors) {

        this.factors = factors;
        return this;
    }

    /**
     * URL to retrieve individual user&#39;s factor enrollments
     *
     * @return factors
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "URL to retrieve individual user's factor enrollments")
    @JsonProperty(JSON_PROPERTY_FACTORS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObject getFactors() {
        return factors;
    }

    @JsonProperty(JSON_PROPERTY_FACTORS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFactors(HrefObject factors) {
        this.factors = factors;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BaseContextUserLinks baseContextUserLinks = (BaseContextUserLinks) o;
        return Objects.equals(this.groups, baseContextUserLinks.groups)
                && Objects.equals(this.factors, baseContextUserLinks.factors);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(groups, factors);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BaseContextUserLinks {\n");
        sb.append("    groups: ").append(toIndentedString(groups)).append("\n");
        sb.append("    factors: ").append(toIndentedString(factors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
