package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.CatalogApplicationStatus;
import com.okta.sdk.resource.model.LinksSelf;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * CatalogApplication
 */
@JsonPropertyOrder({ CatalogApplication.JSON_PROPERTY_CATEGORY, CatalogApplication.JSON_PROPERTY_DESCRIPTION,
        CatalogApplication.JSON_PROPERTY_DISPLAY_NAME, CatalogApplication.JSON_PROPERTY_FEATURES,
        CatalogApplication.JSON_PROPERTY_ID, CatalogApplication.JSON_PROPERTY_LAST_UPDATED,
        CatalogApplication.JSON_PROPERTY_NAME, CatalogApplication.JSON_PROPERTY_SIGN_ON_MODES,
        CatalogApplication.JSON_PROPERTY_STATUS, CatalogApplication.JSON_PROPERTY_VERIFICATION_STATUS,
        CatalogApplication.JSON_PROPERTY_WEBSITE, CatalogApplication.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class CatalogApplication implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CATEGORY = "category";
    private String category;

    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;

    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName;

    public static final String JSON_PROPERTY_FEATURES = "features";
    private List<String> features = null;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_SIGN_ON_MODES = "signOnModes";
    private List<String> signOnModes = null;

    public static final String JSON_PROPERTY_STATUS = "status";
    private CatalogApplicationStatus status;

    public static final String JSON_PROPERTY_VERIFICATION_STATUS = "verificationStatus";
    private String verificationStatus;

    public static final String JSON_PROPERTY_WEBSITE = "website";
    private String website;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelf links;

    public CatalogApplication() {
    }

    /*
     * @JsonCreator public CatalogApplication(
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated ) { this(); this.id = id; this.lastUpdated =
     * lastUpdated; }
     */

    public CatalogApplication category(String category) {

        this.category = category;
        return this;
    }

    /**
     * Get category
     *
     * @return category
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CATEGORY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCategory() {
        return category;
    }

    @JsonProperty(JSON_PROPERTY_CATEGORY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCategory(String category) {
        this.category = category;
    }

    public CatalogApplication description(String description) {

        this.description = description;
        return this;
    }

    /**
     * Get description
     *
     * @return description
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDescription() {
        return description;
    }

    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public CatalogApplication displayName(String displayName) {

        this.displayName = displayName;
        return this;
    }

    /**
     * Get displayName
     *
     * @return displayName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDisplayName() {
        return displayName;
    }

    @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CatalogApplication features(List<String> features) {

        this.features = features;
        return this;
    }

    public CatalogApplication addfeaturesItem(String featuresItem) {
        if (this.features == null) {
            this.features = new ArrayList<>();
        }
        this.features.add(featuresItem);
        return this;
    }

    /**
     * Get features
     *
     * @return features
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_FEATURES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getFeatures() {
        return features;
    }

    @JsonProperty(JSON_PROPERTY_FEATURES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFeatures(List<String> features) {
        this.features = features;
    }

    /**
     * Get id
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * Get lastUpdated
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }

    public CatalogApplication name(String name) {

        this.name = name;
        return this;
    }

    /**
     * Get name
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public CatalogApplication signOnModes(List<String> signOnModes) {

        this.signOnModes = signOnModes;
        return this;
    }

    public CatalogApplication addsignOnModesItem(String signOnModesItem) {
        if (this.signOnModes == null) {
            this.signOnModes = new ArrayList<>();
        }
        this.signOnModes.add(signOnModesItem);
        return this;
    }

    /**
     * Get signOnModes
     *
     * @return signOnModes
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SIGN_ON_MODES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getSignOnModes() {
        return signOnModes;
    }

    @JsonProperty(JSON_PROPERTY_SIGN_ON_MODES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSignOnModes(List<String> signOnModes) {
        this.signOnModes = signOnModes;
    }

    public CatalogApplication status(CatalogApplicationStatus status) {

        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public CatalogApplicationStatus getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(CatalogApplicationStatus status) {
        this.status = status;
    }

    public CatalogApplication verificationStatus(String verificationStatus) {

        this.verificationStatus = verificationStatus;
        return this;
    }

    /**
     * Get verificationStatus
     *
     * @return verificationStatus
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_VERIFICATION_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getVerificationStatus() {
        return verificationStatus;
    }

    @JsonProperty(JSON_PROPERTY_VERIFICATION_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setVerificationStatus(String verificationStatus) {
        this.verificationStatus = verificationStatus;
    }

    public CatalogApplication website(String website) {

        this.website = website;
        return this;
    }

    /**
     * Get website
     *
     * @return website
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_WEBSITE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getWebsite() {
        return website;
    }

    @JsonProperty(JSON_PROPERTY_WEBSITE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setWebsite(String website) {
        this.website = website;
    }

    public CatalogApplication links(LinksSelf links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LinksSelf getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelf links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CatalogApplication catalogApplication = (CatalogApplication) o;
        return Objects.equals(this.category, catalogApplication.category)
                && Objects.equals(this.description, catalogApplication.description)
                && Objects.equals(this.displayName, catalogApplication.displayName)
                && Objects.equals(this.features, catalogApplication.features)
                && Objects.equals(this.id, catalogApplication.id)
                && Objects.equals(this.lastUpdated, catalogApplication.lastUpdated)
                && Objects.equals(this.name, catalogApplication.name)
                && Objects.equals(this.signOnModes, catalogApplication.signOnModes)
                && Objects.equals(this.status, catalogApplication.status)
                && Objects.equals(this.verificationStatus, catalogApplication.verificationStatus)
                && Objects.equals(this.website, catalogApplication.website)
                && Objects.equals(this.links, catalogApplication.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(category, description, displayName, features, id, lastUpdated, name, signOnModes, status,
                verificationStatus, website, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CatalogApplication {\n");
        sb.append("    category: ").append(toIndentedString(category)).append("\n");
        sb.append("    description: ").append(toIndentedString(description)).append("\n");
        sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
        sb.append("    features: ").append(toIndentedString(features)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    signOnModes: ").append(toIndentedString(signOnModes)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    verificationStatus: ").append(toIndentedString(verificationStatus)).append("\n");
        sb.append("    website: ").append(toIndentedString(website)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
