package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.DevicePolicyRuleConditionAssurance;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * &lt;x-lifecycle class&#x3D;\&quot;oie\&quot;&gt;&lt;/x-lifecycle&gt; Specifies the device condition to match on
 */
@ApiModel(description = "<x-lifecycle class=\"oie\"></x-lifecycle> Specifies the device condition to match on")
@JsonPropertyOrder({ DeviceAccessPolicyRuleCondition.JSON_PROPERTY_ASSURANCE,
        DeviceAccessPolicyRuleCondition.JSON_PROPERTY_MANAGED,
        DeviceAccessPolicyRuleCondition.JSON_PROPERTY_REGISTERED })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class DeviceAccessPolicyRuleCondition implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ASSURANCE = "assurance";
    private DevicePolicyRuleConditionAssurance assurance;

    public static final String JSON_PROPERTY_MANAGED = "managed";
    private Boolean managed;

    public static final String JSON_PROPERTY_REGISTERED = "registered";
    private Boolean registered;

    public DeviceAccessPolicyRuleCondition() {
    }

    public DeviceAccessPolicyRuleCondition assurance(DevicePolicyRuleConditionAssurance assurance) {

        this.assurance = assurance;
        return this;
    }

    /**
     * Get assurance
     *
     * @return assurance
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ASSURANCE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public DevicePolicyRuleConditionAssurance getAssurance() {
        return assurance;
    }

    @JsonProperty(JSON_PROPERTY_ASSURANCE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAssurance(DevicePolicyRuleConditionAssurance assurance) {
        this.assurance = assurance;
    }

    public DeviceAccessPolicyRuleCondition managed(Boolean managed) {

        this.managed = managed;
        return this;
    }

    /**
     * Indicates if the device is managed. A device is considered managed if it&#39;s part of a device management
     * system.
     *
     * @return managed
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates if the device is managed. A device is considered managed if it's part of a device management system.")
    @JsonProperty(JSON_PROPERTY_MANAGED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getManaged() {
        return managed;
    }

    @JsonProperty(JSON_PROPERTY_MANAGED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setManaged(Boolean managed) {
        this.managed = managed;
    }

    public DeviceAccessPolicyRuleCondition registered(Boolean registered) {

        this.registered = registered;
        return this;
    }

    /**
     * Indicates if the device is registered. A device is registered if the User enrolls with Okta Verify that&#39;s
     * installed on the device. When the &#x60;managed&#x60; property is passed, you must also include the
     * &#x60;registered&#x60; property and set it to &#x60;true&#x60;.
     *
     * @return registered
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates if the device is registered. A device is registered if the User enrolls with Okta Verify that's installed on the device. When the `managed` property is passed, you must also include the `registered` property and set it to `true`. ")
    @JsonProperty(JSON_PROPERTY_REGISTERED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getRegistered() {
        return registered;
    }

    @JsonProperty(JSON_PROPERTY_REGISTERED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRegistered(Boolean registered) {
        this.registered = registered;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeviceAccessPolicyRuleCondition deviceAccessPolicyRuleCondition = (DeviceAccessPolicyRuleCondition) o;
        return Objects.equals(this.assurance, deviceAccessPolicyRuleCondition.assurance)
                && Objects.equals(this.managed, deviceAccessPolicyRuleCondition.managed)
                && Objects.equals(this.registered, deviceAccessPolicyRuleCondition.registered);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(assurance, managed, registered);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeviceAccessPolicyRuleCondition {\n");
        sb.append("    assurance: ").append(toIndentedString(assurance)).append("\n");
        sb.append("    managed: ").append(toIndentedString(managed)).append("\n");
        sb.append("    registered: ").append(toIndentedString(registered)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
