package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.DeviceAssurance;
import com.okta.sdk.resource.model.DeviceAssuranceAndroidPlatformAllOfScreenLockType;
import com.okta.sdk.resource.model.LinksSelf;
import com.okta.sdk.resource.model.OSVersion;
import com.okta.sdk.resource.model.Platform;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * DeviceAssuranceIOSPlatform
 */
@JsonPropertyOrder({ DeviceAssuranceIOSPlatform.JSON_PROPERTY_JAILBREAK,
        DeviceAssuranceIOSPlatform.JSON_PROPERTY_OS_VERSION,
        DeviceAssuranceIOSPlatform.JSON_PROPERTY_SCREEN_LOCK_TYPE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "platform", visible = true, defaultImpl = DeviceAssuranceIOSPlatform.class)

public class DeviceAssuranceIOSPlatform extends DeviceAssurance implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_JAILBREAK = "jailbreak";
    private Boolean jailbreak;

    public static final String JSON_PROPERTY_OS_VERSION = "osVersion";
    private OSVersion osVersion;

    public static final String JSON_PROPERTY_SCREEN_LOCK_TYPE = "screenLockType";
    private DeviceAssuranceAndroidPlatformAllOfScreenLockType screenLockType;

    public DeviceAssuranceIOSPlatform() {
    }

    /*
     * @JsonCreator public DeviceAssuranceIOSPlatform(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED_BY) String createdBy,
     *
     * @JsonProperty(JSON_PROPERTY_CREATED_DATE) String createdDate,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATE) String lastUpdate,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED_BY) String lastUpdatedBy ) { this(); this.createdBy = createdBy;
     * this.createdDate = createdDate; this.id = id; this.lastUpdate = lastUpdate; this.lastUpdatedBy = lastUpdatedBy; }
     */

    public DeviceAssuranceIOSPlatform jailbreak(Boolean jailbreak) {

        this.jailbreak = jailbreak;
        return this;
    }

    /**
     * Get jailbreak
     *
     * @return jailbreak
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_JAILBREAK)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getJailbreak() {
        return jailbreak;
    }

    @JsonProperty(JSON_PROPERTY_JAILBREAK)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setJailbreak(Boolean jailbreak) {
        this.jailbreak = jailbreak;
    }

    public DeviceAssuranceIOSPlatform osVersion(OSVersion osVersion) {

        this.osVersion = osVersion;
        return this;
    }

    /**
     * Get osVersion
     *
     * @return osVersion
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_OS_VERSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OSVersion getOsVersion() {
        return osVersion;
    }

    @JsonProperty(JSON_PROPERTY_OS_VERSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOsVersion(OSVersion osVersion) {
        this.osVersion = osVersion;
    }

    public DeviceAssuranceIOSPlatform screenLockType(DeviceAssuranceAndroidPlatformAllOfScreenLockType screenLockType) {

        this.screenLockType = screenLockType;
        return this;
    }

    /**
     * Get screenLockType
     *
     * @return screenLockType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SCREEN_LOCK_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public DeviceAssuranceAndroidPlatformAllOfScreenLockType getScreenLockType() {
        return screenLockType;
    }

    @JsonProperty(JSON_PROPERTY_SCREEN_LOCK_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setScreenLockType(DeviceAssuranceAndroidPlatformAllOfScreenLockType screenLockType) {
        this.screenLockType = screenLockType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeviceAssuranceIOSPlatform deviceAssuranceIOSPlatform = (DeviceAssuranceIOSPlatform) o;
        return Objects.equals(this.jailbreak, deviceAssuranceIOSPlatform.jailbreak)
                && Objects.equals(this.osVersion, deviceAssuranceIOSPlatform.osVersion)
                && Objects.equals(this.screenLockType, deviceAssuranceIOSPlatform.screenLockType);
        // && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(jailbreak, osVersion, screenLockType, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeviceAssuranceIOSPlatform {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    jailbreak: ").append(toIndentedString(jailbreak)).append("\n");
        sb.append("    osVersion: ").append(toIndentedString(osVersion)).append("\n");
        sb.append("    screenLockType: ").append(toIndentedString(screenLockType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
