package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Display name of the device
 */
@ApiModel(description = "Display name of the device")
@JsonPropertyOrder({ DeviceDisplayName.JSON_PROPERTY_SENSITIVE, DeviceDisplayName.JSON_PROPERTY_VALUE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class DeviceDisplayName implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_SENSITIVE = "sensitive";
    private Boolean sensitive;

    public static final String JSON_PROPERTY_VALUE = "value";
    private String value;

    public DeviceDisplayName() {
    }

    public DeviceDisplayName sensitive(Boolean sensitive) {

        this.sensitive = sensitive;
        return this;
    }

    /**
     * Get sensitive
     *
     * @return sensitive
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SENSITIVE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getSensitive() {
        return sensitive;
    }

    @JsonProperty(JSON_PROPERTY_SENSITIVE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSensitive(Boolean sensitive) {
        this.sensitive = sensitive;
    }

    public DeviceDisplayName value(String value) {

        this.value = value;
        return this;
    }

    /**
     * Get value
     *
     * @return value
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getValue() {
        return value;
    }

    @JsonProperty(JSON_PROPERTY_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeviceDisplayName deviceDisplayName = (DeviceDisplayName) o;
        return Objects.equals(this.sensitive, deviceDisplayName.sensitive)
                && Objects.equals(this.value, deviceDisplayName.value);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(sensitive, value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeviceDisplayName {\n");
        sb.append("    sensitive: ").append(toIndentedString(sensitive)).append("\n");
        sb.append("    value: ").append(toIndentedString(value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
