package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Certificate metadata for the domain
 */
@ApiModel(description = "Certificate metadata for the domain")
@JsonPropertyOrder({ DomainCertificateMetadata.JSON_PROPERTY_EXPIRATION,
        DomainCertificateMetadata.JSON_PROPERTY_FINGERPRINT, DomainCertificateMetadata.JSON_PROPERTY_SUBJECT })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class DomainCertificateMetadata implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_EXPIRATION = "expiration";
    private String expiration;

    public static final String JSON_PROPERTY_FINGERPRINT = "fingerprint";
    private String fingerprint;

    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private String subject;

    public DomainCertificateMetadata() {
    }

    public DomainCertificateMetadata expiration(String expiration) {

        this.expiration = expiration;
        return this;
    }

    /**
     * Certificate expiration
     *
     * @return expiration
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2021-05-11T05:13:05.000Z", value = "Certificate expiration")
    @JsonProperty(JSON_PROPERTY_EXPIRATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getExpiration() {
        return expiration;
    }

    @JsonProperty(JSON_PROPERTY_EXPIRATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setExpiration(String expiration) {
        this.expiration = expiration;
    }

    public DomainCertificateMetadata fingerprint(String fingerprint) {

        this.fingerprint = fingerprint;
        return this;
    }

    /**
     * Certificate fingerprint
     *
     * @return fingerprint
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "73:68:82:7B:83:2E:48:29:A5:5E:E8:40:41:80:B3:AA:03:C4:42:43:05:73:45:BC:AA:47:00:23:A3:70:E5:C4", value = "Certificate fingerprint")
    @JsonProperty(JSON_PROPERTY_FINGERPRINT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getFingerprint() {
        return fingerprint;
    }

    @JsonProperty(JSON_PROPERTY_FINGERPRINT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public DomainCertificateMetadata subject(String subject) {

        this.subject = subject;
        return this;
    }

    /**
     * Certificate subject
     *
     * @return subject
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "CN=login.example.com", value = "Certificate subject")
    @JsonProperty(JSON_PROPERTY_SUBJECT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getSubject() {
        return subject;
    }

    @JsonProperty(JSON_PROPERTY_SUBJECT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DomainCertificateMetadata domainCertificateMetadata = (DomainCertificateMetadata) o;
        return Objects.equals(this.expiration, domainCertificateMetadata.expiration)
                && Objects.equals(this.fingerprint, domainCertificateMetadata.fingerprint)
                && Objects.equals(this.subject, domainCertificateMetadata.subject);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(expiration, fingerprint, subject);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DomainCertificateMetadata {\n");
        sb.append("    expiration: ").append(toIndentedString(expiration)).append("\n");
        sb.append("    fingerprint: ").append(toIndentedString(fingerprint)).append("\n");
        sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
