package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * EmailDomain
 */
@JsonPropertyOrder({ EmailDomain.JSON_PROPERTY_BRAND_ID, EmailDomain.JSON_PROPERTY_DOMAIN,
        EmailDomain.JSON_PROPERTY_VALIDATION_SUBDOMAIN, EmailDomain.JSON_PROPERTY_DISPLAY_NAME,
        EmailDomain.JSON_PROPERTY_USER_NAME })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class EmailDomain implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_BRAND_ID = "brandId";
    private String brandId;

    public static final String JSON_PROPERTY_DOMAIN = "domain";
    private String domain;

    public static final String JSON_PROPERTY_VALIDATION_SUBDOMAIN = "validationSubdomain";
    private String validationSubdomain = "mail";

    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName;

    public static final String JSON_PROPERTY_USER_NAME = "userName";
    private String userName;

    public EmailDomain() {
    }

    public EmailDomain brandId(String brandId) {

        this.brandId = brandId;
        return this;
    }

    /**
     * Get brandId
     *
     * @return brandId
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_BRAND_ID)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getBrandId() {
        return brandId;
    }

    @JsonProperty(JSON_PROPERTY_BRAND_ID)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setBrandId(String brandId) {
        this.brandId = brandId;
    }

    public EmailDomain domain(String domain) {

        this.domain = domain;
        return this;
    }

    /**
     * Get domain
     *
     * @return domain
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_DOMAIN)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getDomain() {
        return domain;
    }

    @JsonProperty(JSON_PROPERTY_DOMAIN)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setDomain(String domain) {
        this.domain = domain;
    }

    public EmailDomain validationSubdomain(String validationSubdomain) {

        this.validationSubdomain = validationSubdomain;
        return this;
    }

    /**
     * Subdomain for the email sender&#39;s custom mail domain. Specify your subdomain when you configure a custom mail
     * domain.
     *
     * @return validationSubdomain
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Subdomain for the email sender's custom mail domain. Specify your subdomain when you configure a custom mail domain.")
    @JsonProperty(JSON_PROPERTY_VALIDATION_SUBDOMAIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getValidationSubdomain() {
        return validationSubdomain;
    }

    @JsonProperty(JSON_PROPERTY_VALIDATION_SUBDOMAIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setValidationSubdomain(String validationSubdomain) {
        this.validationSubdomain = validationSubdomain;
    }

    public EmailDomain displayName(String displayName) {

        this.displayName = displayName;
        return this;
    }

    /**
     * Get displayName
     *
     * @return displayName
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getDisplayName() {
        return displayName;
    }

    @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public EmailDomain userName(String userName) {

        this.userName = userName;
        return this;
    }

    /**
     * Get userName
     *
     * @return userName
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_USER_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getUserName() {
        return userName;
    }

    @JsonProperty(JSON_PROPERTY_USER_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EmailDomain emailDomain = (EmailDomain) o;
        return Objects.equals(this.brandId, emailDomain.brandId) && Objects.equals(this.domain, emailDomain.domain)
                && Objects.equals(this.validationSubdomain, emailDomain.validationSubdomain)
                && Objects.equals(this.displayName, emailDomain.displayName)
                && Objects.equals(this.userName, emailDomain.userName);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(brandId, domain, validationSubdomain, displayName, userName);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmailDomain {\n");
        sb.append("    brandId: ").append(toIndentedString(brandId)).append("\n");
        sb.append("    domain: ").append(toIndentedString(domain)).append("\n");
        sb.append("    validationSubdomain: ").append(toIndentedString(validationSubdomain)).append("\n");
        sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
        sb.append("    userName: ").append(toIndentedString(userName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
