package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * EmailTestAddresses
 */
@JsonPropertyOrder({ EmailTestAddresses.JSON_PROPERTY_FROM, EmailTestAddresses.JSON_PROPERTY_TO })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class EmailTestAddresses implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_FROM = "from";
    private String from;

    public static final String JSON_PROPERTY_TO = "to";
    private String to;

    public EmailTestAddresses() {
    }

    public EmailTestAddresses from(String from) {

        this.from = from;
        return this;
    }

    /**
     * Email address that sends test emails
     *
     * @return from
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "sender@host.com", required = true, value = "Email address that sends test emails")
    @JsonProperty(JSON_PROPERTY_FROM)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getFrom() {
        return from;
    }

    @JsonProperty(JSON_PROPERTY_FROM)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setFrom(String from) {
        this.from = from;
    }

    public EmailTestAddresses to(String to) {

        this.to = to;
        return this;
    }

    /**
     * Email address that receives test emails
     *
     * @return to
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "receiver@host.com", required = true, value = "Email address that receives test emails")
    @JsonProperty(JSON_PROPERTY_TO)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getTo() {
        return to;
    }

    @JsonProperty(JSON_PROPERTY_TO)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setTo(String to) {
        this.to = to;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EmailTestAddresses emailTestAddresses = (EmailTestAddresses) o;
        return Objects.equals(this.from, emailTestAddresses.from) && Objects.equals(this.to, emailTestAddresses.to);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(from, to);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmailTestAddresses {\n");
        sb.append("    from: ").append(toIndentedString(from)).append("\n");
        sb.append("    to: ").append(toIndentedString(to)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
