package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Fulfillment provider details
 */
@ApiModel(description = "Fulfillment provider details")
@JsonPropertyOrder({ FulfillmentData.JSON_PROPERTY_CUSTOMIZATION_ID, FulfillmentData.JSON_PROPERTY_INVENTORY_PRODUCT_ID,
        FulfillmentData.JSON_PROPERTY_PRODUCT_ID })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class FulfillmentData implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CUSTOMIZATION_ID = "customizationId";
    private String customizationId;

    public static final String JSON_PROPERTY_INVENTORY_PRODUCT_ID = "inventoryProductId";
    private String inventoryProductId;

    public static final String JSON_PROPERTY_PRODUCT_ID = "productId";
    private String productId;

    public FulfillmentData() {
    }

    public FulfillmentData customizationId(String customizationId) {

        this.customizationId = customizationId;
        return this;
    }

    /**
     * ID for the set of custom configurations of the requested Factor
     *
     * @return customizationId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "ID for the set of custom configurations of the requested Factor")
    @JsonProperty(JSON_PROPERTY_CUSTOMIZATION_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCustomizationId() {
        return customizationId;
    }

    @JsonProperty(JSON_PROPERTY_CUSTOMIZATION_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCustomizationId(String customizationId) {
        this.customizationId = customizationId;
    }

    public FulfillmentData inventoryProductId(String inventoryProductId) {

        this.inventoryProductId = inventoryProductId;
        return this;
    }

    /**
     * ID for the specific inventory bucket of the requested Factor
     *
     * @return inventoryProductId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "ID for the specific inventory bucket of the requested Factor")
    @JsonProperty(JSON_PROPERTY_INVENTORY_PRODUCT_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getInventoryProductId() {
        return inventoryProductId;
    }

    @JsonProperty(JSON_PROPERTY_INVENTORY_PRODUCT_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setInventoryProductId(String inventoryProductId) {
        this.inventoryProductId = inventoryProductId;
    }

    public FulfillmentData productId(String productId) {

        this.productId = productId;
        return this;
    }

    /**
     * ID for the make and model of the requested Factor
     *
     * @return productId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "ID for the make and model of the requested Factor")
    @JsonProperty(JSON_PROPERTY_PRODUCT_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getProductId() {
        return productId;
    }

    @JsonProperty(JSON_PROPERTY_PRODUCT_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProductId(String productId) {
        this.productId = productId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FulfillmentData fulfillmentData = (FulfillmentData) o;
        return Objects.equals(this.customizationId, fulfillmentData.customizationId)
                && Objects.equals(this.inventoryProductId, fulfillmentData.inventoryProductId)
                && Objects.equals(this.productId, fulfillmentData.productId);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(customizationId, inventoryProductId, productId);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FulfillmentData {\n");
        sb.append("    customizationId: ").append(toIndentedString(customizationId)).append("\n");
        sb.append("    inventoryProductId: ").append(toIndentedString(inventoryProductId)).append("\n");
        sb.append("    productId: ").append(toIndentedString(productId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
