package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Defines Okta specific [group-rules
 * expression](https://developer.okta.com/docs/reference/okta-expression-language/#expressions-in-group-rules)
 */
@ApiModel(description = "Defines Okta specific [group-rules expression](https://developer.okta.com/docs/reference/okta-expression-language/#expressions-in-group-rules)")
@JsonPropertyOrder({ GroupRuleExpression.JSON_PROPERTY_TYPE, GroupRuleExpression.JSON_PROPERTY_VALUE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class GroupRuleExpression implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public static final String JSON_PROPERTY_VALUE = "value";
    private String value;

    public GroupRuleExpression() {
    }

    public GroupRuleExpression type(String type) {

        this.type = type;
        return this;
    }

    /**
     * Expression type. Only valid value is &#39;&#x60;urn:okta:expression:1.0&#x60;&#39;.
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Expression type. Only valid value is '`urn:okta:expression:1.0`'.")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public GroupRuleExpression value(String value) {

        this.value = value;
        return this;
    }

    /**
     * Okta expression that would result in a Boolean value
     *
     * @return value
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "user.role==\\\"Engineer\\\"", value = "Okta expression that would result in a Boolean value")
    @JsonProperty(JSON_PROPERTY_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getValue() {
        return value;
    }

    @JsonProperty(JSON_PROPERTY_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GroupRuleExpression groupRuleExpression = (GroupRuleExpression) o;
        return Objects.equals(this.type, groupRuleExpression.type)
                && Objects.equals(this.value, groupRuleExpression.value);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(type, value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupRuleExpression {\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    value: ").append(toIndentedString(value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
