package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LogGeolocation;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Geographical context describes a set of geographic coordinates. In addition to containing latitude and longitude
 * data, the &#x60;GeographicalContext&#x60; object also contains address data of postal code-level granularity. Within
 * the &#x60;Client&#x60; object, the geographical context refers to the physical location of the client when it sends
 * the request that triggers this event. All &#x60;Transaction&#x60; events with &#x60;type&#x60; equal to
 * &#x60;WEB&#x60; have a geographical context set. &#x60;Transaction&#x60; events with &#x60;type&#x60; equal to
 * &#x60;JOB&#x60; don&#39;t have a geographical context set. The geographical context data can be missing if the
 * geographical data for a request can&#39;t be resolved.
 */
@ApiModel(description = "Geographical context describes a set of geographic coordinates. In addition to containing latitude and longitude data, the `GeographicalContext` object also contains address data of postal code-level granularity. Within the `Client` object, the geographical context refers to the physical location of the client when it sends the request that triggers this event. All `Transaction` events with `type` equal to `WEB` have a geographical context set. `Transaction` events with `type` equal to `JOB` don't have a geographical context set. The geographical context data can be missing if the geographical data for a request can't be resolved.")
@JsonPropertyOrder({ LogGeographicalContext.JSON_PROPERTY_CITY, LogGeographicalContext.JSON_PROPERTY_COUNTRY,
        LogGeographicalContext.JSON_PROPERTY_GEOLOCATION, LogGeographicalContext.JSON_PROPERTY_POSTAL_CODE,
        LogGeographicalContext.JSON_PROPERTY_STATE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class LogGeographicalContext implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CITY = "city";
    private String city;

    public static final String JSON_PROPERTY_COUNTRY = "country";
    private String country;

    public static final String JSON_PROPERTY_GEOLOCATION = "geolocation";
    private LogGeolocation geolocation;

    public static final String JSON_PROPERTY_POSTAL_CODE = "postalCode";
    private String postalCode;

    public static final String JSON_PROPERTY_STATE = "state";
    private String state;

    public LogGeographicalContext() {
    }

    /*
     * @JsonCreator public LogGeographicalContext(
     *
     * @JsonProperty(JSON_PROPERTY_CITY) String city,
     *
     * @JsonProperty(JSON_PROPERTY_COUNTRY) String country,
     *
     * @JsonProperty(JSON_PROPERTY_POSTAL_CODE) String postalCode,
     *
     * @JsonProperty(JSON_PROPERTY_STATE) String state ) { this(); this.city = city; this.country = country;
     * this.postalCode = postalCode; this.state = state; }
     */

    /**
     * The city that encompasses the area that contains the geolocation coordinates, if available (for example, Seattle,
     * San Francisco)
     *
     * @return city
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The city that encompasses the area that contains the geolocation coordinates, if available (for example, Seattle, San Francisco)")
    @JsonProperty(JSON_PROPERTY_CITY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCity() {
        return city;
    }

    /**
     * Full name of the country that encompasses the area that contains the geolocation coordinates (for example,
     * France, Uganda)
     *
     * @return country
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Full name of the country that encompasses the area that contains the geolocation coordinates (for example, France, Uganda)")
    @JsonProperty(JSON_PROPERTY_COUNTRY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCountry() {
        return country;
    }

    public LogGeographicalContext geolocation(LogGeolocation geolocation) {

        this.geolocation = geolocation;
        return this;
    }

    /**
     * Get geolocation
     *
     * @return geolocation
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_GEOLOCATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LogGeolocation getGeolocation() {
        return geolocation;
    }

    @JsonProperty(JSON_PROPERTY_GEOLOCATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setGeolocation(LogGeolocation geolocation) {
        this.geolocation = geolocation;
    }

    /**
     * Postal code of the area that encompasses the geolocation coordinates
     *
     * @return postalCode
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Postal code of the area that encompasses the geolocation coordinates")
    @JsonProperty(JSON_PROPERTY_POSTAL_CODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getPostalCode() {
        return postalCode;
    }

    /**
     * Full name of the state or province that encompasses the area that contains the geolocation coordinates (for
     * example, Montana, Ontario)
     *
     * @return state
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Full name of the state or province that encompasses the area that contains the geolocation coordinates (for example, Montana, Ontario)")
    @JsonProperty(JSON_PROPERTY_STATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getState() {
        return state;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LogGeographicalContext logGeographicalContext = (LogGeographicalContext) o;
        return Objects.equals(this.city, logGeographicalContext.city)
                && Objects.equals(this.country, logGeographicalContext.country)
                && Objects.equals(this.geolocation, logGeographicalContext.geolocation)
                && Objects.equals(this.postalCode, logGeographicalContext.postalCode)
                && Objects.equals(this.state, logGeographicalContext.state);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(city, country, geolocation, postalCode, state);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogGeographicalContext {\n");
        sb.append("    city: ").append(toIndentedString(city)).append("\n");
        sb.append("    country: ").append(toIndentedString(country)).append("\n");
        sb.append("    geolocation: ").append(toIndentedString(geolocation)).append("\n");
        sb.append("    postalCode: ").append(toIndentedString(postalCode)).append("\n");
        sb.append("    state: ").append(toIndentedString(state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
