package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.SplunkEdition;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies the configuration for the &#x60;splunk_cloud_logstreaming&#x60; Log Stream type.
 */
@ApiModel(description = "Specifies the configuration for the `splunk_cloud_logstreaming` Log Stream type.")
@JsonPropertyOrder({ LogStreamSettingsSplunkPut.JSON_PROPERTY_EDITION, LogStreamSettingsSplunkPut.JSON_PROPERTY_HOST })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class LogStreamSettingsSplunkPut implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_EDITION = "edition";
    private SplunkEdition edition;

    public static final String JSON_PROPERTY_HOST = "host";
    private String host;

    public LogStreamSettingsSplunkPut() {
    }

    public LogStreamSettingsSplunkPut edition(SplunkEdition edition) {

        this.edition = edition;
        return this;
    }

    /**
     * Get edition
     *
     * @return edition
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_EDITION)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public SplunkEdition getEdition() {
        return edition;
    }

    @JsonProperty(JSON_PROPERTY_EDITION)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setEdition(SplunkEdition edition) {
        this.edition = edition;
    }

    public LogStreamSettingsSplunkPut host(String host) {

        this.host = host;
        return this;
    }

    /**
     * The domain name for your Splunk Cloud instance. Don&#39;t include &#x60;http&#x60; or &#x60;https&#x60; in the
     * string. For example: &#x60;acme.splunkcloud.com&#x60;
     *
     * @return host
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "acme.splunkcloud.com", required = true, value = "The domain name for your Splunk Cloud instance. Don't include `http` or `https` in the string. For example: `acme.splunkcloud.com`")
    @JsonProperty(JSON_PROPERTY_HOST)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getHost() {
        return host;
    }

    @JsonProperty(JSON_PROPERTY_HOST)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LogStreamSettingsSplunkPut logStreamSettingsSplunkPut = (LogStreamSettingsSplunkPut) o;
        return Objects.equals(this.edition, logStreamSettingsSplunkPut.edition)
                && Objects.equals(this.host, logStreamSettingsSplunkPut.host);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(edition, host);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogStreamSettingsSplunkPut {\n");
        sb.append("    edition: ").append(toIndentedString(edition)).append("\n");
        sb.append("    host: ").append(toIndentedString(host)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
