package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Details on the target&#39;s changes. Not all event types support the &#x60;changeDetails&#x60; property, and not all
 * &#x60;target&#x60; objects contain the &#x60;changeDetails&#x60; property. You must include a property within the
 * object. &gt; **Note:** When querying the &#x60;changeDetails&#x60; property, you can&#39;t search on the
 * &#x60;to&#x60; or &#x60;from&#x60; objects alone. You must include a property within the object.
 */
@ApiModel(description = "Details on the target's changes. Not all event types support the `changeDetails` property, and not all `target` objects contain the `changeDetails` property. You must include a property within the object.  > **Note:** When querying the `changeDetails` property, you can't search on the `to` or `from` objects alone. You must include a property within the object.")
@JsonPropertyOrder({ LogTargetChangeDetails.JSON_PROPERTY_FROM, LogTargetChangeDetails.JSON_PROPERTY_TO })
@JsonTypeName("LogTarget_changeDetails")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class LogTargetChangeDetails implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_FROM = "from";
    private Map<String, Object> from = null;

    public static final String JSON_PROPERTY_TO = "to";
    private Map<String, Object> to = null;

    public LogTargetChangeDetails() {
    }

    public LogTargetChangeDetails from(Map<String, Object> from) {

        this.from = from;
        return this;
    }

    public LogTargetChangeDetails putfromItem(String key, Object fromItem) {
        if (this.from == null) {
            this.from = new HashMap<>();
        }
        this.from.put(key, fromItem);
        return this;
    }

    /**
     * The original properties of the target
     *
     * @return from
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The original properties of the target")
    @JsonProperty(JSON_PROPERTY_FROM)
    @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getFrom() {
        return from;
    }

    @JsonProperty(JSON_PROPERTY_FROM)
    @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
    public void setFrom(Map<String, Object> from) {
        this.from = from;
    }

    public LogTargetChangeDetails to(Map<String, Object> to) {

        this.to = to;
        return this;
    }

    public LogTargetChangeDetails puttoItem(String key, Object toItem) {
        if (this.to == null) {
            this.to = new HashMap<>();
        }
        this.to.put(key, toItem);
        return this;
    }

    /**
     * The updated properties of the target
     *
     * @return to
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The updated properties of the target")
    @JsonProperty(JSON_PROPERTY_TO)
    @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getTo() {
        return to;
    }

    @JsonProperty(JSON_PROPERTY_TO)
    @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
    public void setTo(Map<String, Object> to) {
        this.to = to;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LogTargetChangeDetails logTargetChangeDetails = (LogTargetChangeDetails) o;
        return Objects.equals(this.from, logTargetChangeDetails.from)
                && Objects.equals(this.to, logTargetChangeDetails.to);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(from, to);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogTargetChangeDetails {\n");
        sb.append("    from: ").append(toIndentedString(from)).append("\n");
        sb.append("    to: ").append(toIndentedString(to)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
