package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * OAuth2ClientSecretRequestBody
 */
@JsonPropertyOrder({ OAuth2ClientSecretRequestBody.JSON_PROPERTY_CLIENT_SECRET,
        OAuth2ClientSecretRequestBody.JSON_PROPERTY_STATUS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class OAuth2ClientSecretRequestBody implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CLIENT_SECRET = "client_secret";
    private String clientSecret;

    /**
     * Status of the OAuth 2.0 Client Secret
     */
    public enum StatusEnum {
        ACTIVE("ACTIVE"),

        INACTIVE("INACTIVE"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;

    public OAuth2ClientSecretRequestBody() {
    }

    public OAuth2ClientSecretRequestBody clientSecret(String clientSecret) {

        this.clientSecret = clientSecret;
        return this;
    }

    /**
     * The OAuth 2.0 client secret string
     *
     * @return clientSecret
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "DRUFXGF9XbLn......a3x3POBiIxDreBCdZuFs5B", value = "The OAuth 2.0 client secret string")
    @JsonProperty(JSON_PROPERTY_CLIENT_SECRET)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getClientSecret() {
        return clientSecret;
    }

    @JsonProperty(JSON_PROPERTY_CLIENT_SECRET)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public OAuth2ClientSecretRequestBody status(StatusEnum status) {

        this.status = status;
        return this;
    }

    /**
     * Status of the OAuth 2.0 Client Secret
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "ACTIVE", value = "Status of the OAuth 2.0 Client Secret")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public StatusEnum getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OAuth2ClientSecretRequestBody oauth2ClientSecretRequestBody = (OAuth2ClientSecretRequestBody) o;
        return Objects.equals(this.clientSecret, oauth2ClientSecretRequestBody.clientSecret)
                && Objects.equals(this.status, oauth2ClientSecretRequestBody.status);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(clientSecret, status);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuth2ClientSecretRequestBody {\n");
        sb.append("    clientSecret: ").append(toIndentedString(clientSecret)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
