package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.OSVersionDynamicVersionRequirement;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies the OS requirement for the policy. There are two types of OS requirements: * **Static**: A specific OS
 * version requirement that doesn&#39;t change until you update the policy. A static OS requirement is specified with
 * the &#x60;osVersion.minimum&#x60; property. * **Dynamic**: An OS version requirement that is relative to the latest
 * major OS release and security patch. A dynamic OS requirement is specified with the
 * &#x60;osVersion.dynamicVersionRequirement&#x60; property. &gt; **Note:** Dynamic OS requirements are available only
 * if the **Dynamic OS version compliance** [self-service
 * EA](/openapi/okta-management/guides/release-lifecycle/#early-access-ea) feature is enabled. You can&#39;t specify
 * both &#x60;osVersion.minimum&#x60; and &#x60;osVersion.dynamicVersionRequirement&#x60; properties at the same time.
 */
@ApiModel(description = "Specifies the OS requirement for the policy.  There are two types of OS requirements:  * **Static**: A specific OS version requirement that doesn't change until you update the policy. A static OS requirement is specified with the `osVersion.minimum` property. * **Dynamic**: An OS version requirement that is relative to the latest major OS release and security patch. A dynamic OS requirement is specified with the `osVersion.dynamicVersionRequirement` property. > **Note:** Dynamic OS requirements are available only if the **Dynamic OS version compliance** [self-service EA](/openapi/okta-management/guides/release-lifecycle/#early-access-ea) feature is enabled. You can't specify both `osVersion.minimum` and `osVersion.dynamicVersionRequirement` properties at the same time. ")
@JsonPropertyOrder({ OSVersion.JSON_PROPERTY_DYNAMIC_VERSION_REQUIREMENT, OSVersion.JSON_PROPERTY_MINIMUM })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class OSVersion implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DYNAMIC_VERSION_REQUIREMENT = "dynamicVersionRequirement";
    private OSVersionDynamicVersionRequirement dynamicVersionRequirement;

    public static final String JSON_PROPERTY_MINIMUM = "minimum";
    private String minimum;

    public OSVersion() {
    }

    public OSVersion dynamicVersionRequirement(OSVersionDynamicVersionRequirement dynamicVersionRequirement) {

        this.dynamicVersionRequirement = dynamicVersionRequirement;
        return this;
    }

    /**
     * Get dynamicVersionRequirement
     *
     * @return dynamicVersionRequirement
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_DYNAMIC_VERSION_REQUIREMENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OSVersionDynamicVersionRequirement getDynamicVersionRequirement() {
        return dynamicVersionRequirement;
    }

    @JsonProperty(JSON_PROPERTY_DYNAMIC_VERSION_REQUIREMENT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDynamicVersionRequirement(OSVersionDynamicVersionRequirement dynamicVersionRequirement) {
        this.dynamicVersionRequirement = dynamicVersionRequirement;
    }

    public OSVersion minimum(String minimum) {

        this.minimum = minimum;
        return this;
    }

    /**
     * The device version must be equal to or newer than the specified version string (maximum of three components for
     * iOS and macOS, and maximum of four components for Android)
     *
     * @return minimum
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "12.4.5", value = "The device version must be equal to or newer than the specified version string (maximum of three components for iOS and macOS, and maximum of four components for Android)")
    @JsonProperty(JSON_PROPERTY_MINIMUM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getMinimum() {
        return minimum;
    }

    @JsonProperty(JSON_PROPERTY_MINIMUM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMinimum(String minimum) {
        this.minimum = minimum;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OSVersion osVersion = (OSVersion) o;
        return Objects.equals(this.dynamicVersionRequirement, osVersion.dynamicVersionRequirement)
                && Objects.equals(this.minimum, osVersion.minimum);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(dynamicVersionRequirement, minimum);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OSVersion {\n");
        sb.append("    dynamicVersionRequirement: ").append(toIndentedString(dynamicVersionRequirement)).append("\n");
        sb.append("    minimum: ").append(toIndentedString(minimum)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
