package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Current version of the operating system (maximum of four components in the versioning scheme)
 */
@ApiModel(description = "Current version of the operating system (maximum of four components in the versioning scheme)")
@JsonPropertyOrder({ OSVersionFourComponents.JSON_PROPERTY_MINIMUM })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class OSVersionFourComponents implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_MINIMUM = "minimum";
    private String minimum;

    public OSVersionFourComponents() {
    }

    public OSVersionFourComponents minimum(String minimum) {

        this.minimum = minimum;
        return this;
    }

    /**
     * Get minimum
     *
     * @return minimum
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "12.4.5.9", value = "")
    @JsonProperty(JSON_PROPERTY_MINIMUM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getMinimum() {
        return minimum;
    }

    @JsonProperty(JSON_PROPERTY_MINIMUM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMinimum(String minimum) {
        this.minimum = minimum;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OSVersionFourComponents osVersionFourComponents = (OSVersionFourComponents) o;
        return Objects.equals(this.minimum, osVersionFourComponents.minimum);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(minimum);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OSVersionFourComponents {\n");
        sb.append("    minimum: ").append(toIndentedString(minimum)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
