package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.Conditions;
import com.okta.sdk.resource.model.OperationResponseAssignmentOperationConfigurationActions;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * OperationResponseAssignmentOperationConfiguration
 */
@JsonPropertyOrder({ OperationResponseAssignmentOperationConfiguration.JSON_PROPERTY_ACTIONS,
        OperationResponseAssignmentOperationConfiguration.JSON_PROPERTY_CONDITIONS,
        OperationResponseAssignmentOperationConfiguration.JSON_PROPERTY_ID,
        OperationResponseAssignmentOperationConfiguration.JSON_PROPERTY_NAME })
@JsonTypeName("OperationResponse_assignmentOperation_configuration")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class OperationResponseAssignmentOperationConfiguration implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ACTIONS = "actions";
    private OperationResponseAssignmentOperationConfigurationActions actions;

    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    private Conditions conditions;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public OperationResponseAssignmentOperationConfiguration() {
    }

    public OperationResponseAssignmentOperationConfiguration actions(
            OperationResponseAssignmentOperationConfigurationActions actions) {

        this.actions = actions;
        return this;
    }

    /**
     * Get actions
     *
     * @return actions
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ACTIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OperationResponseAssignmentOperationConfigurationActions getActions() {
        return actions;
    }

    @JsonProperty(JSON_PROPERTY_ACTIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setActions(OperationResponseAssignmentOperationConfigurationActions actions) {
        this.actions = actions;
    }

    public OperationResponseAssignmentOperationConfiguration conditions(Conditions conditions) {

        this.conditions = conditions;
        return this;
    }

    /**
     * Get conditions
     *
     * @return conditions
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CONDITIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Conditions getConditions() {
        return conditions;
    }

    @JsonProperty(JSON_PROPERTY_CONDITIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setConditions(Conditions conditions) {
        this.conditions = conditions;
    }

    public OperationResponseAssignmentOperationConfiguration id(String id) {

        this.id = id;
        return this;
    }

    /**
     * Get id
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public OperationResponseAssignmentOperationConfiguration name(String name) {

        this.name = name;
        return this;
    }

    /**
     * Get name
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OperationResponseAssignmentOperationConfiguration operationResponseAssignmentOperationConfiguration = (OperationResponseAssignmentOperationConfiguration) o;
        return Objects.equals(this.actions, operationResponseAssignmentOperationConfiguration.actions)
                && Objects.equals(this.conditions, operationResponseAssignmentOperationConfiguration.conditions)
                && Objects.equals(this.id, operationResponseAssignmentOperationConfiguration.id)
                && Objects.equals(this.name, operationResponseAssignmentOperationConfiguration.name);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(actions, conditions, id, name);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationResponseAssignmentOperationConfiguration {\n");
        sb.append("    actions: ").append(toIndentedString(actions)).append("\n");
        sb.append("    conditions: ").append(toIndentedString(conditions)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
