package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ApplicationAccessibility;
import com.okta.sdk.resource.model.ApplicationLicensing;
import com.okta.sdk.resource.model.ApplicationLifecycleStatus;
import com.okta.sdk.resource.model.ApplicationVisibility;
import com.okta.sdk.resource.model.Org2OrgApplicationSettings;
import com.okta.sdk.resource.model.SchemeApplicationCredentials;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Schema for the Okta Org2Org app (key name: &#x60;okta_org2org&#x60;) To create an Org2Org app, use the [Create an
 * Application](/openapi/okta-management/management/tag/Application/#tag/Application/operation/createApplication)
 * request with the following parameters in the request body. &gt; **Notes:** &gt; * The Okta Org2Org
 * (&#x60;okta_org2org&#x60;) app isn&#39;t available in Okta Developer Edition orgs. If you need to test this feature
 * in your Developer Edition org, contact your Okta account team. &gt; * The Okta Org2Org app supports
 * &#x60;SAML_2_0&#x60; and &#x60;AUTO_LOGIN&#x60; sign-on modes.
 */
@ApiModel(description = "Schema for the Okta Org2Org app (key name: `okta_org2org`)  To create an Org2Org app, use the [Create an Application](/openapi/okta-management/management/tag/Application/#tag/Application/operation/createApplication) request with the following parameters in the request body. > **Notes:**  > * The Okta Org2Org (`okta_org2org`) app isn't available in Okta Developer Edition orgs. If you need to test this feature in your Developer Edition org, contact your Okta account team. > * The Okta Org2Org app supports `SAML_2_0` and `AUTO_LOGIN` sign-on modes. ")
@JsonPropertyOrder({ Org2OrgApplication.JSON_PROPERTY_ACCESSIBILITY, Org2OrgApplication.JSON_PROPERTY_CREDENTIALS,
        Org2OrgApplication.JSON_PROPERTY_LABEL, Org2OrgApplication.JSON_PROPERTY_LICENSING,
        Org2OrgApplication.JSON_PROPERTY_NAME, Org2OrgApplication.JSON_PROPERTY_PROFILE,
        Org2OrgApplication.JSON_PROPERTY_SIGN_ON_MODE, Org2OrgApplication.JSON_PROPERTY_STATUS,
        Org2OrgApplication.JSON_PROPERTY_VISIBILITY, Org2OrgApplication.JSON_PROPERTY_SETTINGS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class Org2OrgApplication implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ACCESSIBILITY = "accessibility";
    private ApplicationAccessibility accessibility;

    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private SchemeApplicationCredentials credentials;

    public static final String JSON_PROPERTY_LABEL = "label";
    private String label;

    public static final String JSON_PROPERTY_LICENSING = "licensing";
    private ApplicationLicensing licensing;

    /**
     * Gets or Sets name
     */
    public enum NameEnum {
        OKTA_ORG2ORG("okta_org2org"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        NameEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static NameEnum fromValue(String value) {
            for (NameEnum b : NameEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_NAME = "name";
    private NameEnum name;

    public static final String JSON_PROPERTY_PROFILE = "profile";
    private Map<String, Object> profile = null;

    /**
     * Gets or Sets signOnMode
     */
    public enum SignOnModeEnum {
        SAML_2_0("SAML_2_0"),

        AUTO_LOGIN("AUTO_LOGIN"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        SignOnModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static SignOnModeEnum fromValue(String value) {
            for (SignOnModeEnum b : SignOnModeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_SIGN_ON_MODE = "signOnMode";
    private SignOnModeEnum signOnMode = SignOnModeEnum.SAML_2_0;

    public static final String JSON_PROPERTY_STATUS = "status";
    private ApplicationLifecycleStatus status;

    public static final String JSON_PROPERTY_VISIBILITY = "visibility";
    private ApplicationVisibility visibility;

    public static final String JSON_PROPERTY_SETTINGS = "settings";
    private Org2OrgApplicationSettings settings;

    public Org2OrgApplication() {
    }

    public Org2OrgApplication accessibility(ApplicationAccessibility accessibility) {

        this.accessibility = accessibility;
        return this;
    }

    /**
     * Get accessibility
     *
     * @return accessibility
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ACCESSIBILITY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationAccessibility getAccessibility() {
        return accessibility;
    }

    @JsonProperty(JSON_PROPERTY_ACCESSIBILITY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAccessibility(ApplicationAccessibility accessibility) {
        this.accessibility = accessibility;
    }

    public Org2OrgApplication credentials(SchemeApplicationCredentials credentials) {

        this.credentials = credentials;
        return this;
    }

    /**
     * Get credentials
     *
     * @return credentials
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CREDENTIALS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SchemeApplicationCredentials getCredentials() {
        return credentials;
    }

    @JsonProperty(JSON_PROPERTY_CREDENTIALS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCredentials(SchemeApplicationCredentials credentials) {
        this.credentials = credentials;
    }

    public Org2OrgApplication label(String label) {

        this.label = label;
        return this;
    }

    /**
     * User-defined display name for app
     *
     * @return label
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "User-defined display name for app")
    @JsonProperty(JSON_PROPERTY_LABEL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getLabel() {
        return label;
    }

    @JsonProperty(JSON_PROPERTY_LABEL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setLabel(String label) {
        this.label = label;
    }

    public Org2OrgApplication licensing(ApplicationLicensing licensing) {

        this.licensing = licensing;
        return this;
    }

    /**
     * Get licensing
     *
     * @return licensing
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LICENSING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationLicensing getLicensing() {
        return licensing;
    }

    @JsonProperty(JSON_PROPERTY_LICENSING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLicensing(ApplicationLicensing licensing) {
        this.licensing = licensing;
    }

    public Org2OrgApplication name(NameEnum name) {

        this.name = name;
        return this;
    }

    /**
     * Get name
     *
     * @return name
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "okta_org2org", required = true, value = "")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public NameEnum getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setName(NameEnum name) {
        this.name = name;
    }

    public Org2OrgApplication profile(Map<String, Object> profile) {

        this.profile = profile;
        return this;
    }

    public Org2OrgApplication putprofileItem(String key, Object profileItem) {
        if (this.profile == null) {
            this.profile = new HashMap<>();
        }
        this.profile.put(key, profileItem);
        return this;
    }

    /**
     * Contains any valid JSON schema for specifying properties that can be referenced from a request (only available to
     * OAuth 2.0 client apps)
     *
     * @return profile
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Contains any valid JSON schema for specifying properties that can be referenced from a request (only available to OAuth 2.0 client apps)")
    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getProfile() {
        return profile;
    }

    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProfile(Map<String, Object> profile) {
        this.profile = profile;
    }

    public Org2OrgApplication signOnMode(SignOnModeEnum signOnMode) {

        this.signOnMode = signOnMode;
        return this;
    }

    /**
     * Get signOnMode
     *
     * @return signOnMode
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SIGN_ON_MODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SignOnModeEnum getSignOnMode() {
        return signOnMode;
    }

    @JsonProperty(JSON_PROPERTY_SIGN_ON_MODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSignOnMode(SignOnModeEnum signOnMode) {
        this.signOnMode = signOnMode;
    }

    public Org2OrgApplication status(ApplicationLifecycleStatus status) {

        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationLifecycleStatus getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(ApplicationLifecycleStatus status) {
        this.status = status;
    }

    public Org2OrgApplication visibility(ApplicationVisibility visibility) {

        this.visibility = visibility;
        return this;
    }

    /**
     * Get visibility
     *
     * @return visibility
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_VISIBILITY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationVisibility getVisibility() {
        return visibility;
    }

    @JsonProperty(JSON_PROPERTY_VISIBILITY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setVisibility(ApplicationVisibility visibility) {
        this.visibility = visibility;
    }

    public Org2OrgApplication settings(Org2OrgApplicationSettings settings) {

        this.settings = settings;
        return this;
    }

    /**
     * Get settings
     *
     * @return settings
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_SETTINGS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public Org2OrgApplicationSettings getSettings() {
        return settings;
    }

    @JsonProperty(JSON_PROPERTY_SETTINGS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setSettings(Org2OrgApplicationSettings settings) {
        this.settings = settings;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Org2OrgApplication org2OrgApplication = (Org2OrgApplication) o;
        return Objects.equals(this.accessibility, org2OrgApplication.accessibility)
                && Objects.equals(this.credentials, org2OrgApplication.credentials)
                && Objects.equals(this.label, org2OrgApplication.label)
                && Objects.equals(this.licensing, org2OrgApplication.licensing)
                && Objects.equals(this.name, org2OrgApplication.name)
                && Objects.equals(this.profile, org2OrgApplication.profile)
                && Objects.equals(this.signOnMode, org2OrgApplication.signOnMode)
                && Objects.equals(this.status, org2OrgApplication.status)
                && Objects.equals(this.visibility, org2OrgApplication.visibility)
                && Objects.equals(this.settings, org2OrgApplication.settings);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(accessibility, credentials, label, licensing, name, profile, signOnMode, status, visibility,
                settings);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Org2OrgApplication {\n");
        sb.append("    accessibility: ").append(toIndentedString(accessibility)).append("\n");
        sb.append("    credentials: ").append(toIndentedString(credentials)).append("\n");
        sb.append("    label: ").append(toIndentedString(label)).append("\n");
        sb.append("    licensing: ").append(toIndentedString(licensing)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
        sb.append("    signOnMode: ").append(toIndentedString(signOnMode)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    visibility: ").append(toIndentedString(visibility)).append("\n");
        sb.append("    settings: ").append(toIndentedString(settings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
