package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.OrgPreferencesLinksHideEndUserFooter;
import com.okta.sdk.resource.model.OrgPreferencesLinksShowEndUserFooter;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies link relations (see [Web Linking](https://www.rfc-editor.org/rfc/rfc8288)) available for this object using
 * the [JSON Hypertext Application Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06)
 * specification
 */
@ApiModel(description = "Specifies link relations (see [Web Linking](https://www.rfc-editor.org/rfc/rfc8288)) available for this object using the [JSON Hypertext Application Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification")
@JsonPropertyOrder({ OrgPreferencesLinks.JSON_PROPERTY_HIDE_END_USER_FOOTER,
        OrgPreferencesLinks.JSON_PROPERTY_SHOW_END_USER_FOOTER })
@JsonTypeName("OrgPreferences__links")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class OrgPreferencesLinks implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_HIDE_END_USER_FOOTER = "hideEndUserFooter";
    private OrgPreferencesLinksHideEndUserFooter hideEndUserFooter;

    public static final String JSON_PROPERTY_SHOW_END_USER_FOOTER = "showEndUserFooter";
    private OrgPreferencesLinksShowEndUserFooter showEndUserFooter;

    public OrgPreferencesLinks() {
    }

    public OrgPreferencesLinks hideEndUserFooter(OrgPreferencesLinksHideEndUserFooter hideEndUserFooter) {

        this.hideEndUserFooter = hideEndUserFooter;
        return this;
    }

    /**
     * Get hideEndUserFooter
     *
     * @return hideEndUserFooter
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_HIDE_END_USER_FOOTER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OrgPreferencesLinksHideEndUserFooter getHideEndUserFooter() {
        return hideEndUserFooter;
    }

    @JsonProperty(JSON_PROPERTY_HIDE_END_USER_FOOTER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setHideEndUserFooter(OrgPreferencesLinksHideEndUserFooter hideEndUserFooter) {
        this.hideEndUserFooter = hideEndUserFooter;
    }

    public OrgPreferencesLinks showEndUserFooter(OrgPreferencesLinksShowEndUserFooter showEndUserFooter) {

        this.showEndUserFooter = showEndUserFooter;
        return this;
    }

    /**
     * Get showEndUserFooter
     *
     * @return showEndUserFooter
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SHOW_END_USER_FOOTER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OrgPreferencesLinksShowEndUserFooter getShowEndUserFooter() {
        return showEndUserFooter;
    }

    @JsonProperty(JSON_PROPERTY_SHOW_END_USER_FOOTER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setShowEndUserFooter(OrgPreferencesLinksShowEndUserFooter showEndUserFooter) {
        this.showEndUserFooter = showEndUserFooter;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OrgPreferencesLinks orgPreferencesLinks = (OrgPreferencesLinks) o;
        return Objects.equals(this.hideEndUserFooter, orgPreferencesLinks.hideEndUserFooter)
                && Objects.equals(this.showEndUserFooter, orgPreferencesLinks.showEndUserFooter);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(hideEndUserFooter, showEndUserFooter);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrgPreferencesLinks {\n");
        sb.append("    hideEndUserFooter: ").append(toIndentedString(hideEndUserFooter)).append("\n");
        sb.append("    showEndUserFooter: ").append(toIndentedString(showEndUserFooter)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
