package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.PasswordPolicyDelegationSettings;
import com.okta.sdk.resource.model.PasswordPolicyPasswordSettings;
import com.okta.sdk.resource.model.PasswordPolicyRecoverySettings;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * PasswordPolicySettings
 */
@JsonPropertyOrder({ PasswordPolicySettings.JSON_PROPERTY_DELEGATION, PasswordPolicySettings.JSON_PROPERTY_PASSWORD,
        PasswordPolicySettings.JSON_PROPERTY_RECOVERY })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class PasswordPolicySettings implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DELEGATION = "delegation";
    private PasswordPolicyDelegationSettings delegation;

    public static final String JSON_PROPERTY_PASSWORD = "password";
    private PasswordPolicyPasswordSettings password;

    public static final String JSON_PROPERTY_RECOVERY = "recovery";
    private PasswordPolicyRecoverySettings recovery;

    public PasswordPolicySettings() {
    }

    public PasswordPolicySettings delegation(PasswordPolicyDelegationSettings delegation) {

        this.delegation = delegation;
        return this;
    }

    /**
     * Get delegation
     *
     * @return delegation
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_DELEGATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PasswordPolicyDelegationSettings getDelegation() {
        return delegation;
    }

    @JsonProperty(JSON_PROPERTY_DELEGATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDelegation(PasswordPolicyDelegationSettings delegation) {
        this.delegation = delegation;
    }

    public PasswordPolicySettings password(PasswordPolicyPasswordSettings password) {

        this.password = password;
        return this;
    }

    /**
     * Get password
     *
     * @return password
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PASSWORD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PasswordPolicyPasswordSettings getPassword() {
        return password;
    }

    @JsonProperty(JSON_PROPERTY_PASSWORD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPassword(PasswordPolicyPasswordSettings password) {
        this.password = password;
    }

    public PasswordPolicySettings recovery(PasswordPolicyRecoverySettings recovery) {

        this.recovery = recovery;
        return this;
    }

    /**
     * Get recovery
     *
     * @return recovery
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_RECOVERY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PasswordPolicyRecoverySettings getRecovery() {
        return recovery;
    }

    @JsonProperty(JSON_PROPERTY_RECOVERY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRecovery(PasswordPolicyRecoverySettings recovery) {
        this.recovery = recovery;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PasswordPolicySettings passwordPolicySettings = (PasswordPolicySettings) o;
        return Objects.equals(this.delegation, passwordPolicySettings.delegation)
                && Objects.equals(this.password, passwordPolicySettings.password)
                && Objects.equals(this.recovery, passwordPolicySettings.recovery);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(delegation, password, recovery);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PasswordPolicySettings {\n");
        sb.append("    delegation: ").append(toIndentedString(delegation)).append("\n");
        sb.append("    password: ").append(toIndentedString(password)).append("\n");
        sb.append("    recovery: ").append(toIndentedString(recovery)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
