package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.PerClientRateLimitMode;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * A map of Per-Client Rate Limit Use Case to the applicable PerClientRateLimitMode. Overrides the
 * &#x60;defaultMode&#x60; property for the specified use cases.
 */
@ApiModel(description = "A map of Per-Client Rate Limit Use Case to the applicable PerClientRateLimitMode. Overrides the `defaultMode` property for the specified use cases.")
@JsonPropertyOrder({ PerClientRateLimitSettingsUseCaseModeOverrides.JSON_PROPERTY_L_O_G_I_N_P_A_G_E,
        PerClientRateLimitSettingsUseCaseModeOverrides.JSON_PROPERTY_O_A_U_T_H2_A_U_T_H_O_R_I_Z_E,
        PerClientRateLimitSettingsUseCaseModeOverrides.JSON_PROPERTY_O_I_E_A_P_P_I_N_T_E_N_T })
@JsonTypeName("PerClientRateLimitSettings_useCaseModeOverrides")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class PerClientRateLimitSettingsUseCaseModeOverrides implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_L_O_G_I_N_P_A_G_E = "LOGIN_PAGE";
    private PerClientRateLimitMode LOGIN_PAGE;

    public static final String JSON_PROPERTY_O_A_U_T_H2_A_U_T_H_O_R_I_Z_E = "OAUTH2_AUTHORIZE";
    private PerClientRateLimitMode OAUTH2_AUTHORIZE;

    public static final String JSON_PROPERTY_O_I_E_A_P_P_I_N_T_E_N_T = "OIE_APP_INTENT";
    private PerClientRateLimitMode OIE_APP_INTENT;

    public PerClientRateLimitSettingsUseCaseModeOverrides() {
    }

    public PerClientRateLimitSettingsUseCaseModeOverrides LOGIN_PAGE(PerClientRateLimitMode LOGIN_PAGE) {

        this.LOGIN_PAGE = LOGIN_PAGE;
        return this;
    }

    /**
     * Get LOGIN_PAGE
     *
     * @return LOGIN_PAGE
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_L_O_G_I_N_P_A_G_E)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PerClientRateLimitMode getLOGINPAGE() {
        return LOGIN_PAGE;
    }

    @JsonProperty(JSON_PROPERTY_L_O_G_I_N_P_A_G_E)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLOGINPAGE(PerClientRateLimitMode LOGIN_PAGE) {
        this.LOGIN_PAGE = LOGIN_PAGE;
    }

    public PerClientRateLimitSettingsUseCaseModeOverrides OAUTH2_AUTHORIZE(PerClientRateLimitMode OAUTH2_AUTHORIZE) {

        this.OAUTH2_AUTHORIZE = OAUTH2_AUTHORIZE;
        return this;
    }

    /**
     * Get OAUTH2_AUTHORIZE
     *
     * @return OAUTH2_AUTHORIZE
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_O_A_U_T_H2_A_U_T_H_O_R_I_Z_E)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PerClientRateLimitMode getOAUTH2AUTHORIZE() {
        return OAUTH2_AUTHORIZE;
    }

    @JsonProperty(JSON_PROPERTY_O_A_U_T_H2_A_U_T_H_O_R_I_Z_E)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOAUTH2AUTHORIZE(PerClientRateLimitMode OAUTH2_AUTHORIZE) {
        this.OAUTH2_AUTHORIZE = OAUTH2_AUTHORIZE;
    }

    public PerClientRateLimitSettingsUseCaseModeOverrides OIE_APP_INTENT(PerClientRateLimitMode OIE_APP_INTENT) {

        this.OIE_APP_INTENT = OIE_APP_INTENT;
        return this;
    }

    /**
     * Get OIE_APP_INTENT
     *
     * @return OIE_APP_INTENT
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_O_I_E_A_P_P_I_N_T_E_N_T)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PerClientRateLimitMode getOIEAPPINTENT() {
        return OIE_APP_INTENT;
    }

    @JsonProperty(JSON_PROPERTY_O_I_E_A_P_P_I_N_T_E_N_T)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOIEAPPINTENT(PerClientRateLimitMode OIE_APP_INTENT) {
        this.OIE_APP_INTENT = OIE_APP_INTENT;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PerClientRateLimitSettingsUseCaseModeOverrides perClientRateLimitSettingsUseCaseModeOverrides = (PerClientRateLimitSettingsUseCaseModeOverrides) o;
        return Objects.equals(this.LOGIN_PAGE, perClientRateLimitSettingsUseCaseModeOverrides.LOGIN_PAGE)
                && Objects.equals(this.OAUTH2_AUTHORIZE,
                        perClientRateLimitSettingsUseCaseModeOverrides.OAUTH2_AUTHORIZE)
                && Objects.equals(this.OIE_APP_INTENT, perClientRateLimitSettingsUseCaseModeOverrides.OIE_APP_INTENT);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(LOGIN_PAGE, OAUTH2_AUTHORIZE, OIE_APP_INTENT);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PerClientRateLimitSettingsUseCaseModeOverrides {\n");
        sb.append("    LOGIN_PAGE: ").append(toIndentedString(LOGIN_PAGE)).append("\n");
        sb.append("    OAUTH2_AUTHORIZE: ").append(toIndentedString(OAUTH2_AUTHORIZE)).append("\n");
        sb.append("    OIE_APP_INTENT: ").append(toIndentedString(OIE_APP_INTENT)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
