package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Rule type
 */
public enum PolicyRuleType {

    ACCESS_POLICY("ACCESS_POLICY"),

    ENTITY_RISK("ENTITY_RISK"),

    IDP_DISCOVERY("IDP_DISCOVERY"),

    MFA_ENROLL("MFA_ENROLL"),

    PASSWORD("PASSWORD"),

    POST_AUTH_SESSION("POST_AUTH_SESSION"),

    PROFILE_ENROLLMENT("PROFILE_ENROLLMENT"),

    RESOURCE_ACCESS("RESOURCE_ACCESS"),

    SIGN_ON("SIGN_ON"),

    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    PolicyRuleType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static PolicyRuleType fromValue(String value) {
        for (PolicyRuleType b : PolicyRuleType.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    /**
     * Convert the instance into URL query string.
     *
     * @param prefix
     *            prefix of the query string
     *
     * @return URL query string
     */
    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }

        return String.format("%s=%s", prefix, this.toString().toString());
    }
}
