package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * [Okta Expression Language (EL) expression](https://developer.okta.com/docs/reference/okta-expression-language/) to
 * generate or transform a unique username for the IdP User. * IdP User profile attributes can be referenced with the
 * &#x60;idpuser&#x60; prefix such as &#x60;idpuser.subjectNameId&#x60;. * You must define an IdP User profile attribute
 * before it can be referenced in an Okta EL expression. To define an IdP User attribute policy, you may need to create
 * a new IdP instance without a base profile property. Then edit the IdP User profile to update the IdP instance with an
 * expression that references the IdP User profile attribute that you just created.
 */
@ApiModel(description = "[Okta Expression Language (EL) expression](https://developer.okta.com/docs/reference/okta-expression-language/) to generate or transform a unique username for the IdP User. * IdP User profile attributes can be referenced with the `idpuser` prefix such as `idpuser.subjectNameId`. * You must define an IdP User profile attribute before it can be referenced in an Okta EL expression. To define an IdP User attribute policy, you may need to create a new IdP instance without a base profile property. Then edit the IdP User profile to update the IdP instance with an expression that references the IdP User profile attribute that you just created.")
@JsonPropertyOrder({ PolicyUserNameTemplate.JSON_PROPERTY_TEMPLATE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class PolicyUserNameTemplate implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_TEMPLATE = "template";
    private String template;

    public PolicyUserNameTemplate() {
    }

    public PolicyUserNameTemplate template(String template) {

        this.template = template;
        return this;
    }

    /**
     * Get template
     *
     * @return template
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "idpuser.subjectNameId", value = "")
    @JsonProperty(JSON_PROPERTY_TEMPLATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getTemplate() {
        return template;
    }

    @JsonProperty(JSON_PROPERTY_TEMPLATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTemplate(String template) {
        this.template = template;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PolicyUserNameTemplate policyUserNameTemplate = (PolicyUserNameTemplate) o;
        return Objects.equals(this.template, policyUserNameTemplate.template);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(template);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PolicyUserNameTemplate {\n");
        sb.append("    template: ").append(toIndentedString(template)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
