package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LifecycleStatus;
import com.okta.sdk.resource.model.PolicyLinks;
import com.okta.sdk.resource.model.PolicyRule;
import com.okta.sdk.resource.model.PolicyRuleType;
import com.okta.sdk.resource.model.PostAuthSessionPolicyRuleAllOfActions;
import com.okta.sdk.resource.model.PostAuthSessionPolicyRuleAllOfConditions;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * PostAuthSessionPolicyRule
 */
@JsonPropertyOrder({ PostAuthSessionPolicyRule.JSON_PROPERTY_ACTIONS,
        PostAuthSessionPolicyRule.JSON_PROPERTY_CONDITIONS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "type", visible = true, defaultImpl = PostAuthSessionPolicyRule.class)

public class PostAuthSessionPolicyRule extends PolicyRule implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ACTIONS = "actions";
    private PostAuthSessionPolicyRuleAllOfActions actions;

    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    private PostAuthSessionPolicyRuleAllOfConditions conditions;

    public PostAuthSessionPolicyRule() {
    }

    /*
     * @JsonCreator public PostAuthSessionPolicyRule(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated ) { this(); this.created = created;
     * this.lastUpdated = lastUpdated; }
     */

    public PostAuthSessionPolicyRule actions(PostAuthSessionPolicyRuleAllOfActions actions) {

        this.actions = actions;
        return this;
    }

    /**
     * Get actions
     *
     * @return actions
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ACTIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PostAuthSessionPolicyRuleAllOfActions getActions() {
        return actions;
    }

    @JsonProperty(JSON_PROPERTY_ACTIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setActions(PostAuthSessionPolicyRuleAllOfActions actions) {
        this.actions = actions;
    }

    public PostAuthSessionPolicyRule conditions(PostAuthSessionPolicyRuleAllOfConditions conditions) {

        this.conditions = conditions;
        return this;
    }

    /**
     * Get conditions
     *
     * @return conditions
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CONDITIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PostAuthSessionPolicyRuleAllOfConditions getConditions() {
        return conditions;
    }

    @JsonProperty(JSON_PROPERTY_CONDITIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setConditions(PostAuthSessionPolicyRuleAllOfConditions conditions) {
        this.conditions = conditions;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PostAuthSessionPolicyRule postAuthSessionPolicyRule = (PostAuthSessionPolicyRule) o;
        return Objects.equals(this.actions, postAuthSessionPolicyRule.actions)
                && Objects.equals(this.conditions, postAuthSessionPolicyRule.conditions);
        // && super.equals(o);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b
                || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
    }

    @Override
    public int hashCode() {
        return Objects.hash(actions, conditions, super.hashCode());
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[] { a.get() }) : 31;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostAuthSessionPolicyRule {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    actions: ").append(toIndentedString(actions)).append("\n");
        sb.append("    conditions: ").append(toIndentedString(conditions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
