package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.PrivilegedAccountCredentials;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Details for a SaaS Application Account, which will be managed as a Privileged Account
 */
@ApiModel(description = "Details for a SaaS Application Account, which will be managed as a Privileged Account")
@JsonPropertyOrder({ PrivilegedAccountDetailsAppAccountSub.JSON_PROPERTY_APP_GLOBAL_NAME,
        PrivilegedAccountDetailsAppAccountSub.JSON_PROPERTY_APP_INSTANCE_NAME,
        PrivilegedAccountDetailsAppAccountSub.JSON_PROPERTY_CREDENTIALS,
        PrivilegedAccountDetailsAppAccountSub.JSON_PROPERTY_OKTA_APPLICATION_ID })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class PrivilegedAccountDetailsAppAccountSub implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_APP_GLOBAL_NAME = "appGlobalName";
    private String appGlobalName;

    public static final String JSON_PROPERTY_APP_INSTANCE_NAME = "appInstanceName";
    private String appInstanceName;

    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private PrivilegedAccountCredentials credentials;

    public static final String JSON_PROPERTY_OKTA_APPLICATION_ID = "oktaApplicationId";
    private String oktaApplicationId;

    public PrivilegedAccountDetailsAppAccountSub() {
    }

    public PrivilegedAccountDetailsAppAccountSub appGlobalName(String appGlobalName) {

        this.appGlobalName = appGlobalName;
        return this;
    }

    /**
     * The name of the SaaS Application in the Okta Integration Network catalog
     *
     * @return appGlobalName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "Salesforce", value = "The name of the SaaS Application in the Okta Integration Network catalog")
    @JsonProperty(JSON_PROPERTY_APP_GLOBAL_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAppGlobalName() {
        return appGlobalName;
    }

    @JsonProperty(JSON_PROPERTY_APP_GLOBAL_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAppGlobalName(String appGlobalName) {
        this.appGlobalName = appGlobalName;
    }

    public PrivilegedAccountDetailsAppAccountSub appInstanceName(String appInstanceName) {

        this.appInstanceName = appInstanceName;
        return this;
    }

    /**
     * The instance name of the SaaS Application
     *
     * @return appInstanceName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "Salesforce Prod", value = "The instance name of the SaaS Application")
    @JsonProperty(JSON_PROPERTY_APP_INSTANCE_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAppInstanceName() {
        return appInstanceName;
    }

    @JsonProperty(JSON_PROPERTY_APP_INSTANCE_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAppInstanceName(String appInstanceName) {
        this.appInstanceName = appInstanceName;
    }

    public PrivilegedAccountDetailsAppAccountSub credentials(PrivilegedAccountCredentials credentials) {

        this.credentials = credentials;
        return this;
    }

    /**
     * Get credentials
     *
     * @return credentials
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_CREDENTIALS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public PrivilegedAccountCredentials getCredentials() {
        return credentials;
    }

    @JsonProperty(JSON_PROPERTY_CREDENTIALS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setCredentials(PrivilegedAccountCredentials credentials) {
        this.credentials = credentials;
    }

    public PrivilegedAccountDetailsAppAccountSub oktaApplicationId(String oktaApplicationId) {

        this.oktaApplicationId = oktaApplicationId;
        return this;
    }

    /**
     * The Okta app instance ID of the SaaS Application
     *
     * @return oktaApplicationId
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "aln1aqcs055ZRoizW0g8", required = true, value = "The Okta app instance ID of the SaaS Application")
    @JsonProperty(JSON_PROPERTY_OKTA_APPLICATION_ID)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getOktaApplicationId() {
        return oktaApplicationId;
    }

    @JsonProperty(JSON_PROPERTY_OKTA_APPLICATION_ID)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setOktaApplicationId(String oktaApplicationId) {
        this.oktaApplicationId = oktaApplicationId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PrivilegedAccountDetailsAppAccountSub privilegedAccountDetailsAppAccountSub = (PrivilegedAccountDetailsAppAccountSub) o;
        return Objects.equals(this.appGlobalName, privilegedAccountDetailsAppAccountSub.appGlobalName)
                && Objects.equals(this.appInstanceName, privilegedAccountDetailsAppAccountSub.appInstanceName)
                && Objects.equals(this.credentials, privilegedAccountDetailsAppAccountSub.credentials)
                && Objects.equals(this.oktaApplicationId, privilegedAccountDetailsAppAccountSub.oktaApplicationId);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(appGlobalName, appInstanceName, credentials, oktaApplicationId);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PrivilegedAccountDetailsAppAccountSub {\n");
        sb.append("    appGlobalName: ").append(toIndentedString(appGlobalName)).append("\n");
        sb.append("    appInstanceName: ").append(toIndentedString(appInstanceName)).append("\n");
        sb.append("    credentials: ").append(toIndentedString(credentials)).append("\n");
        sb.append("    oktaApplicationId: ").append(toIndentedString(oktaApplicationId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
