package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.PrivilegedAccount;
import com.okta.sdk.resource.model.PrivilegedAccountDetailsOktaUserAccountSub;
import com.okta.sdk.resource.model.PrivilegedAccountStatus;
import com.okta.sdk.resource.model.PrivilegedAccountStatusDetail;
import com.okta.sdk.resource.model.PrivilegedAccountType;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Details for managing an Okta Universal Directory Account as a Privileged Account
 */
@ApiModel(description = "Details for managing an Okta Universal Directory Account as a Privileged Account")
@JsonPropertyOrder({ PrivilegedAccountDetailsOktaUserAccount.JSON_PROPERTY_DETAILS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "accountType", visible = true, defaultImpl = PrivilegedAccountDetailsOktaUserAccount.class)

public class PrivilegedAccountDetailsOktaUserAccount extends PrivilegedAccount implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DETAILS = "details";
    private PrivilegedAccountDetailsOktaUserAccountSub details;

    public PrivilegedAccountDetailsOktaUserAccount() {
    }

    /*
     * @JsonCreator public PrivilegedAccountDetailsOktaUserAccount(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated ) { this(); this.created = created; this.id
     * = id; this.lastUpdated = lastUpdated; }
     */

    public PrivilegedAccountDetailsOktaUserAccount details(PrivilegedAccountDetailsOktaUserAccountSub details) {

        this.details = details;
        return this;
    }

    /**
     * Get details
     *
     * @return details
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_DETAILS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public PrivilegedAccountDetailsOktaUserAccountSub getDetails() {
        return details;
    }

    @JsonProperty(JSON_PROPERTY_DETAILS)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setDetails(PrivilegedAccountDetailsOktaUserAccountSub details) {
        this.details = details;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PrivilegedAccountDetailsOktaUserAccount privilegedAccountDetailsOktaUserAccount = (PrivilegedAccountDetailsOktaUserAccount) o;
        return Objects.equals(this.details, privilegedAccountDetailsOktaUserAccount.details);
        // && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(details, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PrivilegedAccountDetailsOktaUserAccount {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    details: ").append(toIndentedString(details)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
