package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.CredentialSyncInfo;
import com.okta.sdk.resource.model.PrivilegedResource;
import com.okta.sdk.resource.model.PrivilegedResourceCredentials;
import com.okta.sdk.resource.model.PrivilegedResourceStatus;
import com.okta.sdk.resource.model.PrivilegedResourceType;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * PrivilegedResourceAccountOkta
 */
@JsonPropertyOrder({ PrivilegedResourceAccountOkta.JSON_PROPERTY_RESOURCE_ID,
        PrivilegedResourceAccountOkta.JSON_PROPERTY_CREDENTIALS, PrivilegedResourceAccountOkta.JSON_PROPERTY_PROFILE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "resourceType", visible = true, defaultImpl = PrivilegedResourceAccountOkta.class)

public class PrivilegedResourceAccountOkta extends PrivilegedResource implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_RESOURCE_ID = "resourceId";
    private String resourceId;

    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private PrivilegedResourceCredentials credentials;

    public static final String JSON_PROPERTY_PROFILE = "profile";
    private Map<String, Object> profile = null;

    public PrivilegedResourceAccountOkta() {
    }

    /*
     * @JsonCreator public PrivilegedResourceAccountOkta(
     *
     * @JsonProperty(JSON_PROPERTY_PROFILE) Map<String, Object> profile,
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated ) { this(); this.profile = profile;
     * this.created = created; this.id = id; this.lastUpdated = lastUpdated; }
     */

    public PrivilegedResourceAccountOkta resourceId(String resourceId) {

        this.resourceId = resourceId;
        return this;
    }

    /**
     * The user ID associated with the Okta privileged resource
     *
     * @return resourceId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "00u100xTfFs4MasRf0g4", value = "The user ID associated with the Okta privileged resource")
    @JsonProperty(JSON_PROPERTY_RESOURCE_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getResourceId() {
        return resourceId;
    }

    @JsonProperty(JSON_PROPERTY_RESOURCE_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public PrivilegedResourceAccountOkta credentials(PrivilegedResourceCredentials credentials) {

        this.credentials = credentials;
        return this;
    }

    /**
     * Get credentials
     *
     * @return credentials
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CREDENTIALS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PrivilegedResourceCredentials getCredentials() {
        return credentials;
    }

    @JsonProperty(JSON_PROPERTY_CREDENTIALS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCredentials(PrivilegedResourceCredentials credentials) {
        this.credentials = credentials;
    }

    /**
     * Specific profile properties for the privileged account
     *
     * @return profile
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Specific profile properties for the privileged account")
    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getProfile() {
        return profile;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PrivilegedResourceAccountOkta privilegedResourceAccountOkta = (PrivilegedResourceAccountOkta) o;
        return Objects.equals(this.resourceId, privilegedResourceAccountOkta.resourceId)
                && Objects.equals(this.credentials, privilegedResourceAccountOkta.credentials)
                && Objects.equals(this.profile, privilegedResourceAccountOkta.profile);
        // && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceId, credentials, profile, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PrivilegedResourceAccountOkta {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    resourceId: ").append(toIndentedString(resourceId)).append("\n");
        sb.append("    credentials: ").append(toIndentedString(credentials)).append("\n");
        sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
