package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ProtocolEndpointBinding;
import com.okta.sdk.resource.model.ProtocolEndpointType;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * ProtocolEndpoint
 */
@JsonPropertyOrder({ ProtocolEndpoint.JSON_PROPERTY_BINDING, ProtocolEndpoint.JSON_PROPERTY_DESTINATION,
        ProtocolEndpoint.JSON_PROPERTY_TYPE, ProtocolEndpoint.JSON_PROPERTY_URL })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class ProtocolEndpoint implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_BINDING = "binding";
    private ProtocolEndpointBinding binding;

    public static final String JSON_PROPERTY_DESTINATION = "destination";
    private String destination;

    public static final String JSON_PROPERTY_TYPE = "type";
    private ProtocolEndpointType type;

    public static final String JSON_PROPERTY_URL = "url";
    private String url;

    public ProtocolEndpoint() {
    }

    public ProtocolEndpoint binding(ProtocolEndpointBinding binding) {

        this.binding = binding;
        return this;
    }

    /**
     * Get binding
     *
     * @return binding
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_BINDING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ProtocolEndpointBinding getBinding() {
        return binding;
    }

    @JsonProperty(JSON_PROPERTY_BINDING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setBinding(ProtocolEndpointBinding binding) {
        this.binding = binding;
    }

    public ProtocolEndpoint destination(String destination) {

        this.destination = destination;
        return this;
    }

    /**
     * Get destination
     *
     * @return destination
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_DESTINATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDestination() {
        return destination;
    }

    @JsonProperty(JSON_PROPERTY_DESTINATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDestination(String destination) {
        this.destination = destination;
    }

    public ProtocolEndpoint type(ProtocolEndpointType type) {

        this.type = type;
        return this;
    }

    /**
     * Get type
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ProtocolEndpointType getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(ProtocolEndpointType type) {
        this.type = type;
    }

    public ProtocolEndpoint url(String url) {

        this.url = url;
        return this;
    }

    /**
     * Get url
     *
     * @return url
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUrl() {
        return url;
    }

    @JsonProperty(JSON_PROPERTY_URL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProtocolEndpoint protocolEndpoint = (ProtocolEndpoint) o;
        return Objects.equals(this.binding, protocolEndpoint.binding)
                && Objects.equals(this.destination, protocolEndpoint.destination)
                && Objects.equals(this.type, protocolEndpoint.type) && Objects.equals(this.url, protocolEndpoint.url);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(binding, destination, type, url);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProtocolEndpoint {\n");
        sb.append("    binding: ").append(toIndentedString(binding)).append("\n");
        sb.append("    destination: ").append(toIndentedString(destination)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    url: ").append(toIndentedString(url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
