package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.MtlsCredentials;
import com.okta.sdk.resource.model.MtlsEndpoints;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Protocol settings for the [MTLS Protocol](https://tools.ietf.org/html/rfc5246#section-7.4.4)
 */
@ApiModel(description = "Protocol settings for the [MTLS Protocol](https://tools.ietf.org/html/rfc5246#section-7.4.4)")
@JsonPropertyOrder({ ProtocolMtls.JSON_PROPERTY_CREDENTIALS, ProtocolMtls.JSON_PROPERTY_ENDPOINTS,
        ProtocolMtls.JSON_PROPERTY_TYPE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class ProtocolMtls implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private MtlsCredentials credentials;

    public static final String JSON_PROPERTY_ENDPOINTS = "endpoints";
    private MtlsEndpoints endpoints;

    /**
     * Mutual TLS
     */
    public enum TypeEnum {
        MTLS("MTLS"),

        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public ProtocolMtls() {
    }

    public ProtocolMtls credentials(MtlsCredentials credentials) {

        this.credentials = credentials;
        return this;
    }

    /**
     * Get credentials
     *
     * @return credentials
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CREDENTIALS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public MtlsCredentials getCredentials() {
        return credentials;
    }

    @JsonProperty(JSON_PROPERTY_CREDENTIALS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCredentials(MtlsCredentials credentials) {
        this.credentials = credentials;
    }

    public ProtocolMtls endpoints(MtlsEndpoints endpoints) {

        this.endpoints = endpoints;
        return this;
    }

    /**
     * Get endpoints
     *
     * @return endpoints
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ENDPOINTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public MtlsEndpoints getEndpoints() {
        return endpoints;
    }

    @JsonProperty(JSON_PROPERTY_ENDPOINTS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setEndpoints(MtlsEndpoints endpoints) {
        this.endpoints = endpoints;
    }

    public ProtocolMtls type(TypeEnum type) {

        this.type = type;
        return this;
    }

    /**
     * Mutual TLS
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Mutual TLS")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public TypeEnum getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProtocolMtls protocolMtls = (ProtocolMtls) o;
        return Objects.equals(this.credentials, protocolMtls.credentials)
                && Objects.equals(this.endpoints, protocolMtls.endpoints)
                && Objects.equals(this.type, protocolMtls.type);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(credentials, endpoints, type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProtocolMtls {\n");
        sb.append("    credentials: ").append(toIndentedString(credentials)).append("\n");
        sb.append("    endpoints: ").append(toIndentedString(endpoints)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
