package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * RegistrationResponseErrorErrorCausesInner
 */
@JsonPropertyOrder({ RegistrationResponseErrorErrorCausesInner.JSON_PROPERTY_ERROR_SUMMARY,
        RegistrationResponseErrorErrorCausesInner.JSON_PROPERTY_REASON,
        RegistrationResponseErrorErrorCausesInner.JSON_PROPERTY_LOCATION_TYPE,
        RegistrationResponseErrorErrorCausesInner.JSON_PROPERTY_LOCATION,
        RegistrationResponseErrorErrorCausesInner.JSON_PROPERTY_DOMAIN })
@JsonTypeName("RegistrationResponse_Error_errorCauses_inner")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class RegistrationResponseErrorErrorCausesInner implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ERROR_SUMMARY = "errorSummary";
    private String errorSummary;

    public static final String JSON_PROPERTY_REASON = "reason";
    private String reason;

    public static final String JSON_PROPERTY_LOCATION_TYPE = "locationType";
    private String locationType;

    public static final String JSON_PROPERTY_LOCATION = "location";
    private String location;

    public static final String JSON_PROPERTY_DOMAIN = "domain";
    private String domain;

    public RegistrationResponseErrorErrorCausesInner() {
    }

    public RegistrationResponseErrorErrorCausesInner errorSummary(String errorSummary) {

        this.errorSummary = errorSummary;
        return this;
    }

    /**
     * Human-readable summary of the error.
     *
     * @return errorSummary
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Human-readable summary of the error.")
    @JsonProperty(JSON_PROPERTY_ERROR_SUMMARY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getErrorSummary() {
        return errorSummary;
    }

    @JsonProperty(JSON_PROPERTY_ERROR_SUMMARY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setErrorSummary(String errorSummary) {
        this.errorSummary = errorSummary;
    }

    public RegistrationResponseErrorErrorCausesInner reason(String reason) {

        this.reason = reason;
        return this;
    }

    /**
     * A brief, enum-like string that indicates the nature of the error. For example, &#x60;UNIQUE_CONSTRAINT&#x60; for
     * a property uniqueness violation.
     *
     * @return reason
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "A brief, enum-like string that indicates the nature of the error. For example, `UNIQUE_CONSTRAINT` for a property uniqueness violation.")
    @JsonProperty(JSON_PROPERTY_REASON)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getReason() {
        return reason;
    }

    @JsonProperty(JSON_PROPERTY_REASON)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setReason(String reason) {
        this.reason = reason;
    }

    public RegistrationResponseErrorErrorCausesInner locationType(String locationType) {

        this.locationType = locationType;
        return this;
    }

    /**
     * Where in the request the error was found (&#x60;body&#x60;, &#x60;header&#x60;, &#x60;url&#x60;, or
     * &#x60;query&#x60;).
     *
     * @return locationType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Where in the request the error was found (`body`, `header`, `url`, or `query`).")
    @JsonProperty(JSON_PROPERTY_LOCATION_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLocationType() {
        return locationType;
    }

    @JsonProperty(JSON_PROPERTY_LOCATION_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLocationType(String locationType) {
        this.locationType = locationType;
    }

    public RegistrationResponseErrorErrorCausesInner location(String location) {

        this.location = location;
        return this;
    }

    /**
     * The valid JSON path to the location of the error. For example, if there was an error in the user&#39;s
     * &#x60;login&#x60; field, the &#x60;location&#x60; might be &#x60;data.userProfile.login&#x60;.
     *
     * @return location
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The valid JSON path to the location of the error. For example, if there was an error in the user's `login` field, the `location` might be `data.userProfile.login`.")
    @JsonProperty(JSON_PROPERTY_LOCATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLocation() {
        return location;
    }

    @JsonProperty(JSON_PROPERTY_LOCATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLocation(String location) {
        this.location = location;
    }

    public RegistrationResponseErrorErrorCausesInner domain(String domain) {

        this.domain = domain;
        return this;
    }

    /**
     * Indicates the source of the error. If the error was in the user&#39;s profile, for example, you might use
     * &#x60;end-user&#x60;. If the error occurred in the external service, you might use &#x60;external-service&#x60;.
     *
     * @return domain
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates the source of the error. If the error was in the user's profile, for example, you might use `end-user`. If the error occurred in the external service, you might use `external-service`.")
    @JsonProperty(JSON_PROPERTY_DOMAIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDomain() {
        return domain;
    }

    @JsonProperty(JSON_PROPERTY_DOMAIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RegistrationResponseErrorErrorCausesInner registrationResponseErrorErrorCausesInner = (RegistrationResponseErrorErrorCausesInner) o;
        return Objects.equals(this.errorSummary, registrationResponseErrorErrorCausesInner.errorSummary)
                && Objects.equals(this.reason, registrationResponseErrorErrorCausesInner.reason)
                && Objects.equals(this.locationType, registrationResponseErrorErrorCausesInner.locationType)
                && Objects.equals(this.location, registrationResponseErrorErrorCausesInner.location)
                && Objects.equals(this.domain, registrationResponseErrorErrorCausesInner.domain);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(errorSummary, reason, locationType, location, domain);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RegistrationResponseErrorErrorCausesInner {\n");
        sb.append("    errorSummary: ").append(toIndentedString(errorSummary)).append("\n");
        sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
        sb.append("    locationType: ").append(toIndentedString(locationType)).append("\n");
        sb.append("    location: ").append(toIndentedString(location)).append("\n");
        sb.append("    domain: ").append(toIndentedString(domain)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
