package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The value of the claim that you add or replace, and can also include other attributes. If adding to a claim, add
 * another &#x60;value&#x60; attribute residing within an array called &#x60;attributeValues&#x60;. See the following
 * examples: #### Simple value (integer or string) &#x60;\&quot;value\&quot;: 300&#x60; or &#x60;\&quot;value\&quot;:
 * \&quot;replacementString\&quot;&#x60; #### Attribute value (object) &#x60; \&quot;value\&quot;: {
 * \&quot;authContextClassRef\&quot;: \&quot;replacementValue\&quot; }&#x60; #### AttributeValues array value (object)
 * &#x60; \&quot;value\&quot;: { \&quot;attributes\&quot;: { \&quot;NameFormat\&quot;:
 * \&quot;urn:oasis:names:tc:SAML:2.0:attrname-format:basic\&quot; }, \&quot;attributeValues\&quot;: [
 * {\&quot;attributes\&quot;: { \&quot;xsi:type\&quot;: \&quot;xs:string\&quot; }, \&quot;value\&quot;:
 * \&quot;4321\&quot;} ] }&#x60;
 */
@ApiModel(description = "The value of the claim that you add or replace, and can also include other attributes. If adding to a claim, add another `value` attribute residing within an array called `attributeValues`.  See the following examples:  #### Simple value (integer or string)  `\"value\": 300` or `\"value\": \"replacementString\"`  #### Attribute value (object)  ` \"value\": {     \"authContextClassRef\": \"replacementValue\"   }`  #### AttributeValues array value (object)  ` \"value\": {     \"attributes\": {       \"NameFormat\": \"urn:oasis:names:tc:SAML:2.0:attrname-format:basic\"     },     \"attributeValues\": [       {\"attributes\": {         \"xsi:type\": \"xs:string\"       },       \"value\": \"4321\"}       ]     }`")
@JsonPropertyOrder({})
@JsonTypeName("SAMLHookResponse_commands_inner_value_inner_value")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class SAMLHookResponseCommandsInnerValueInnerValue implements Serializable {

    private static final long serialVersionUID = 1L;

    public SAMLHookResponseCommandsInnerValueInnerValue() {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SAMLHookResponseCommandsInnerValueInnerValue {\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
