package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * The format used to generate the &#x60;relayState&#x60; in the SAML request. The &#x60;FROM_URL&#x60; format is used
 * if this value is null.
 */
public enum SamlRelayStateFormat {

    FROM_URL("FROM_URL"),

    OPAQUE("OPAQUE"),

    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    SamlRelayStateFormat(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static SamlRelayStateFormat fromValue(String value) {
        for (SamlRelayStateFormat b : SamlRelayStateFormat.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    /**
     * Convert the instance into URL query string.
     *
     * @param prefix
     *            prefix of the query string
     *
     * @return URL query string
     */
    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }

        return String.format("%s=%s", prefix, this.toString().toString());
    }
}
