package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.Oidc;
import com.okta.sdk.resource.model.Saml;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Supported SSO protocol configurations. You must configure at least one protocol: &#x60;oidc&#x60; or &#x60;saml&#x60;
 */
@ApiModel(description = "Supported SSO protocol configurations. You must configure at least one protocol: `oidc` or `saml`")
@JsonPropertyOrder({ Sso.JSON_PROPERTY_OIDC, Sso.JSON_PROPERTY_SAML })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-01-23T09:50:29.349096-06:00[America/Chicago]", comments = "Generator version: 7.8.0")
public class Sso implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_OIDC = "oidc";
    private Oidc oidc;

    public static final String JSON_PROPERTY_SAML = "saml";
    private Saml saml;

    public Sso() {
    }

    public Sso oidc(Oidc oidc) {

        this.oidc = oidc;
        return this;
    }

    /**
     * Get oidc
     *
     * @return oidc
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_OIDC)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Oidc getOidc() {
        return oidc;
    }

    @JsonProperty(JSON_PROPERTY_OIDC)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOidc(Oidc oidc) {
        this.oidc = oidc;
    }

    public Sso saml(Saml saml) {

        this.saml = saml;
        return this;
    }

    /**
     * Get saml
     *
     * @return saml
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SAML)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Saml getSaml() {
        return saml;
    }

    @JsonProperty(JSON_PROPERTY_SAML)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSaml(Saml saml) {
        this.saml = saml;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Sso sso = (Sso) o;
        return Objects.equals(this.oidc, sso.oidc) && Objects.equals(this.saml, sso.saml);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(oidc, saml);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Sso {\n");
        sb.append("    oidc: ").append(toIndentedString(oidc)).append("\n");
        sb.append("    saml: ").append(toIndentedString(saml)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
